/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.dev;

import com.gitee.starblues.plugin.pack.BasicRepackager;
import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.dev.Dependency;
import com.gitee.starblues.plugin.pack.dev.DevConfig;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.artifact.Artifact;

public class DevRepackager
extends BasicRepackager {
    private Map<String, Dependency> moduleDependencies = Collections.emptyMap();

    public DevRepackager(RepackageMojo repackageMojo) {
        super(repackageMojo);
    }

    @Override
    protected Set<String> getDependenciesIndexSet() throws Exception {
        this.moduleDependencies = this.getModuleDependencies(this.repackageMojo.getDevConfig());
        Set<String> dependenciesIndexSet = super.getDependenciesIndexSet();
        for (Dependency dependency : this.moduleDependencies.values()) {
            dependenciesIndexSet.add(dependency.getClassesPath());
        }
        return dependenciesIndexSet;
    }

    @Override
    protected boolean filterArtifact(Artifact artifact) {
        if (super.filterArtifact(artifact)) {
            return true;
        }
        String moduleDependencyKey = this.getModuleDependencyKey(artifact.getGroupId(), artifact.getArtifactId());
        Dependency dependency = this.moduleDependencies.get(moduleDependencyKey);
        return dependency != null && !ObjectUtils.isEmpty((CharSequence)dependency.getClassesPath());
    }

    protected Map<String, Dependency> getModuleDependencies(DevConfig devConfig) {
        if (devConfig == null) {
            return Collections.emptyMap();
        }
        List<Dependency> moduleDependencies = devConfig.getModuleDependencies();
        if (ObjectUtils.isEmpty(moduleDependencies)) {
            return Collections.emptyMap();
        }
        HashMap<String, Dependency> moduleDependenciesMap = new HashMap<String, Dependency>();
        for (Dependency dependency : moduleDependencies) {
            String moduleDependencyKey = this.getModuleDependencyKey(dependency.getGroupId(), dependency.getArtifactId());
            if (moduleDependencyKey == null) continue;
            moduleDependenciesMap.put(moduleDependencyKey, dependency);
        }
        return moduleDependenciesMap;
    }

    protected String getModuleDependencyKey(String groupId, String artifactId) {
        if (ObjectUtils.isEmpty((CharSequence)groupId) || ObjectUtils.isEmpty((CharSequence)artifactId)) {
            return null;
        }
        return groupId + artifactId;
    }

    public Map<String, Dependency> getModuleDependencies() {
        return this.moduleDependencies;
    }
}

