/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.encrypt;

import com.gitee.starblues.common.cipher.AesPluginCipher;
import com.gitee.starblues.plugin.pack.PluginInfo;
import com.gitee.starblues.plugin.pack.encrypt.AesConfig;
import com.gitee.starblues.plugin.pack.encrypt.EncryptConfig;
import com.gitee.starblues.plugin.pack.encrypt.EncryptPlugin;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;

public class AesEncryptPlugin
implements EncryptPlugin {
    @Override
    public PluginInfo encrypt(EncryptConfig encryptConfig, PluginInfo pluginInfo) throws Exception {
        AesConfig aesConfig = encryptConfig.getAes();
        if (aesConfig == null) {
            return null;
        }
        String secretKey = aesConfig.getSecretKey();
        if (ObjectUtils.isEmpty((CharSequence)secretKey)) {
            throw new MojoExecutionException("encryptConfig.aes.secretKey can't be empty");
        }
        AesPluginCipher pluginCipher = new AesPluginCipher();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("secretKey", secretKey);
        pluginCipher.initParams(params);
        String bootstrapClass = pluginInfo.getBootstrapClass();
        String encrypt = pluginCipher.encrypt(bootstrapClass);
        pluginInfo.setBootstrapClass(encrypt);
        return pluginInfo;
    }
}

