/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.encrypt;

import com.gitee.starblues.common.cipher.RsaPluginCipher;
import com.gitee.starblues.plugin.pack.PluginInfo;
import com.gitee.starblues.plugin.pack.encrypt.EncryptConfig;
import com.gitee.starblues.plugin.pack.encrypt.EncryptPlugin;
import com.gitee.starblues.plugin.pack.encrypt.RsaConfig;
import com.gitee.starblues.utils.ObjectUtils;
import java.util.HashMap;
import org.apache.maven.plugin.MojoExecutionException;

public class RsaEncryptPlugin
implements EncryptPlugin {
    @Override
    public PluginInfo encrypt(EncryptConfig encryptConfig, PluginInfo pluginInfo) throws Exception {
        RsaConfig rsaConfig = encryptConfig.getRsa();
        if (rsaConfig == null) {
            return null;
        }
        String publicKey = rsaConfig.getPublicKey();
        if (ObjectUtils.isEmpty((CharSequence)publicKey)) {
            throw new MojoExecutionException("encryptConfig.rsa.publicKey can't be empty");
        }
        RsaPluginCipher pluginCipher = new RsaPluginCipher();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("publicKey", publicKey);
        pluginCipher.initParams(params);
        String bootstrapClass = pluginInfo.getBootstrapClass();
        pluginInfo.setBootstrapClass(pluginCipher.encrypt(bootstrapClass));
        return pluginInfo;
    }
}

