/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.main;

import com.gitee.starblues.plugin.pack.Constant;
import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.Repackager;
import com.gitee.starblues.plugin.pack.main.MainConfig;
import com.gitee.starblues.plugin.pack.main.MainRepackager;
import com.gitee.starblues.plugin.pack.utils.CommonUtils;
import com.gitee.starblues.plugin.pack.utils.PackageJar;
import java.io.Closeable;
import java.io.File;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JarNestPackager
implements Repackager {
    protected final MainConfig mainConfig;
    protected final RepackageMojo repackageMojo;
    protected PackageJar packageJar;

    public JarNestPackager(MainRepackager mainRepackager) {
        this.mainConfig = mainRepackager.getMainConfig();
        this.repackageMojo = mainRepackager.getRepackageMojo();
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            this.packageJar = new PackageJar(this.mainConfig.getOutputDirectory(), this.mainConfig.getFileName());
            this.writeClasses();
            this.writeDependencies();
            this.writeManifest();
        }
        catch (Exception e) {
            this.repackageMojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException((Throwable)e);
        }
        finally {
            if (this.packageJar != null) {
                IOUtils.closeQuietly((Closeable)this.packageJar);
            }
        }
    }

    protected void writeManifest() throws Exception {
        Manifest manifest = this.getManifest();
        this.packageJar.putDirEntry("META-INF/");
        this.packageJar.write("META-INF/MANIFEST.MF", manifest::write);
    }

    protected Manifest getManifest() throws Exception {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.putValue("Start-Class", this.mainConfig.getMainClass());
        attributes.putValue("Main-Class", "com.gitee.starblues.loader.launcher.SpringMainProdBootstrap");
        return manifest;
    }

    protected void writeClasses() throws Exception {
        String buildDir = this.repackageMojo.getProject().getBuild().getOutputDirectory();
        this.packageJar.copyDirToPackage(new File(buildDir), null);
    }

    protected void writeDependencies() throws Exception {
        Set<Artifact> dependencies = this.repackageMojo.getSourceDependencies();
        String libDirEntryName = this.createLibEntry();
        for (Artifact artifact : dependencies) {
            if (this.filterArtifact(artifact)) continue;
            if (CommonUtils.isPluginFrameworkLoader(artifact)) {
                this.packageJar.copyZipToPackage(artifact.getFile());
                continue;
            }
            this.packageJar.writeDependency(artifact.getFile(), libDirEntryName);
        }
    }

    protected boolean filterArtifact(Artifact artifact) {
        return Constant.scopeFilter(artifact.getScope());
    }

    protected String createLibEntry() throws Exception {
        String libDirEntryName = "lib/";
        this.packageJar.putDirEntry(libDirEntryName);
        return libDirEntryName;
    }
}

