/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.main;

import com.gitee.starblues.plugin.pack.main.JarNestPackager;
import com.gitee.starblues.plugin.pack.main.MainRepackager;
import com.gitee.starblues.utils.FilesUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class JarOuterPackager
extends JarNestPackager {
    private final List<String> dependenciesName = new ArrayList<String>();

    public JarOuterPackager(MainRepackager mainRepackager) {
        super(mainRepackager);
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        String rootDir = this.createRootDir();
        this.mainConfig.setOutputDirectory(rootDir);
        super.repackage();
    }

    @Override
    protected void writeClasses() throws Exception {
        String buildDir = this.repackageMojo.getProject().getBuild().getOutputDirectory();
        this.packageJar.copyDirToPackage(new File(buildDir), "");
    }

    private String createRootDir() throws MojoFailureException {
        String outputDirectory = this.mainConfig.getOutputDirectory();
        String fileName = this.mainConfig.getFileName();
        String rootDirPath = FilesUtils.joiningFilePath((String[])new String[]{outputDirectory, fileName});
        File rootFile = new File(rootDirPath);
        if (rootFile.exists()) {
            rootFile.deleteOnExit();
        }
        if (rootFile.mkdirs()) {
            return rootDirPath;
        }
        throw new MojoFailureException("Create dir failure : " + rootDirPath);
    }

    @Override
    protected Manifest getManifest() throws Exception {
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Manifest-Version", "1.0");
        attributes.remove("Start-Class");
        attributes.putValue("Main-Class", this.mainConfig.getMainClass());
        if (this.dependenciesName.isEmpty()) {
            return manifest;
        }
        String classPathStr = String.join((CharSequence)" ", this.dependenciesName);
        attributes.putValue("Class-Path", classPathStr);
        return manifest;
    }

    @Override
    protected void writeDependencies() throws Exception {
        Set<Artifact> dependencies = this.repackageMojo.getSourceDependencies();
        for (Artifact artifact : dependencies) {
            if (this.filterArtifact(artifact)) continue;
            File artifactFile = artifact.getFile();
            String targetFilePath = FilesUtils.joiningFilePath((String[])new String[]{this.mainConfig.getOutputDirectory(), "lib", artifactFile.getName()});
            FileUtils.copyFile((File)artifactFile, (File)new File(targetFilePath));
            this.dependenciesName.add("lib/" + artifactFile.getName());
        }
    }
}

