/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.main;

import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.Repackager;
import com.gitee.starblues.plugin.pack.main.JarNestPackager;
import com.gitee.starblues.plugin.pack.main.JarOuterPackager;
import com.gitee.starblues.plugin.pack.main.MainConfig;
import com.gitee.starblues.utils.ObjectUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class MainRepackager
implements Repackager {
    private final RepackageMojo repackageMojo;
    private final MainConfig mainConfig;

    public MainRepackager(RepackageMojo repackageMojo) {
        this.repackageMojo = repackageMojo;
        this.mainConfig = repackageMojo.getMainConfig();
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        this.checkConfig();
        String packageType = this.mainConfig.getPackageType();
        if ("jar".equalsIgnoreCase(packageType)) {
            new JarNestPackager(this).repackage();
        } else if ("jar-outer".equalsIgnoreCase(packageType)) {
            new JarOuterPackager(this).repackage();
        } else {
            throw new MojoFailureException("Not found packageType : " + packageType);
        }
    }

    private void checkConfig() throws MojoFailureException {
        String outputDirectory;
        String packageType;
        if (this.mainConfig == null) {
            throw new MojoFailureException("configuration.mainConfig config cannot be empty");
        }
        if (ObjectUtils.isEmpty((CharSequence)this.mainConfig.getMainClass())) {
            throw new MojoFailureException("configuration.mainConfig.mainClass config cannot be empty");
        }
        String fileName = this.mainConfig.getFileName();
        if (ObjectUtils.isEmpty((CharSequence)fileName)) {
            MavenProject project = this.repackageMojo.getProject();
            this.mainConfig.setFileName(project.getArtifactId() + "-" + project.getVersion() + "-repackage");
        }
        if (ObjectUtils.isEmpty((CharSequence)(packageType = this.mainConfig.getPackageType()))) {
            this.mainConfig.setPackageType("jar");
        }
        if (ObjectUtils.isEmpty((CharSequence)(outputDirectory = this.mainConfig.getOutputDirectory()))) {
            this.mainConfig.setOutputDirectory(this.repackageMojo.getOutputDirectory().getPath());
        }
    }

    public RepackageMojo getRepackageMojo() {
        return this.repackageMojo;
    }

    public MainConfig getMainConfig() {
        return this.mainConfig;
    }
}

