/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.prod;

import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.dev.DevRepackager;
import com.gitee.starblues.plugin.pack.prod.ProdConfig;
import com.gitee.starblues.utils.FilesUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class DirProdRepackager
extends DevRepackager {
    protected final ProdConfig prodConfig;

    public DirProdRepackager(RepackageMojo repackageMojo, ProdConfig prodConfig) {
        super(repackageMojo);
        this.prodConfig = prodConfig;
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        super.repackage();
        try {
            this.resolveClasses();
        }
        catch (Exception e) {
            this.repackageMojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException((Throwable)e);
        }
    }

    @Override
    protected String createRootDir() throws MojoFailureException {
        String fileName = this.prodConfig.getFileName();
        String dirPath = FilesUtils.joiningFilePath((String[])new String[]{this.prodConfig.getOutputDirectory(), fileName});
        File dirFile = new File(dirPath);
        if (dirFile.exists() && dirFile.isFile()) {
            int i = 0;
            while ((dirFile = new File(dirPath + "_" + i)).exists() && dirFile.isFile()) {
                ++i;
            }
        }
        dirFile.deleteOnExit();
        if (!dirFile.mkdirs()) {
            throw new MojoFailureException("Create package dir failure: " + dirFile.getPath());
        }
        return dirFile.getPath();
    }

    @Override
    protected String getRelativeManifestPath() {
        return FilesUtils.joiningFilePath((String[])new String[]{"META-INF", "MANIFEST.MF"});
    }

    @Override
    protected String getRelativePluginMetaPath() {
        return FilesUtils.joiningFilePath((String[])new String[]{"META-INF", "PLUGIN.META"});
    }

    @Override
    protected String getRelativeResourcesDefinePath() {
        return FilesUtils.joiningFilePath((String[])new String[]{"META-INF", "RESOURCES.CONF"});
    }

    @Override
    protected Manifest getManifest() throws Exception {
        Manifest manifest = super.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Plugin-Meta-Path", "META-INF/PLUGIN.META");
        attributes.putValue("Plugin-Package-Type", "zip-outer");
        return manifest;
    }

    @Override
    protected Properties createPluginMetaInfo() throws Exception {
        Properties properties = super.createPluginMetaInfo();
        properties.put("plugin.system.path", "classes");
        properties.put("plugin.system.resourcesConfig", "META-INF/RESOURCES.CONF");
        return properties;
    }

    protected void resolveClasses() throws Exception {
        String buildDir = this.repackageMojo.getProject().getBuild().getOutputDirectory();
        String path = FilesUtils.joiningFilePath((String[])new String[]{this.getRootDir(), "classes"});
        File file = new File(path);
        FileUtils.forceMkdir((File)file);
        FileUtils.copyDirectory((File)new File(buildDir), (File)file);
    }

    @Override
    protected Set<String> getDependenciesIndexSet() throws Exception {
        Set<Artifact> dependencies = this.repackageMojo.getFilterDependencies();
        String libDir = this.createLibDir();
        HashSet<String> dependencyIndexNames = new HashSet<String>(dependencies.size());
        for (Artifact artifact : dependencies) {
            if (this.filterArtifact(artifact)) continue;
            File artifactFile = artifact.getFile();
            FileUtils.copyFile((File)artifactFile, (File)new File(FilesUtils.joiningFilePath((String[])new String[]{libDir, artifactFile.getName()})));
            dependencyIndexNames.add("lib/" + artifactFile.getName() + this.repackageMojo.resolveLoadToMain(artifact));
        }
        return dependencyIndexNames;
    }

    protected String createLibDir() throws IOException {
        String dir = FilesUtils.joiningFilePath((String[])new String[]{this.getRootDir(), "lib"});
        File file = new File(dir);
        if (file.mkdir()) {
            return dir;
        }
        throw new IOException("Create lib dir failure");
    }
}

