/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.prod;

import com.gitee.starblues.plugin.pack.PluginInfo;
import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.Repackager;
import com.gitee.starblues.plugin.pack.dev.DevRepackager;
import com.gitee.starblues.plugin.pack.prod.DirProdRepackager;
import com.gitee.starblues.plugin.pack.prod.JarNestedProdRepackager;
import com.gitee.starblues.plugin.pack.prod.JarOuterProdRepackager;
import com.gitee.starblues.plugin.pack.prod.ProdConfig;
import com.gitee.starblues.plugin.pack.prod.ZipOuterProdRepackager;
import com.gitee.starblues.plugin.pack.prod.ZipProdRepackager;
import com.gitee.starblues.utils.ObjectUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ProdRepackager
implements Repackager {
    private ProdConfig prodConfig;
    private final RepackageMojo repackageMojo;
    private final Repackager repackager;

    public ProdRepackager(RepackageMojo repackageMojo) {
        this.repackageMojo = repackageMojo;
        this.repackager = new DevRepackager(repackageMojo);
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        this.repackager.repackage();
        this.prodConfig = this.getProdConfig(this.repackageMojo);
        String packageType = this.prodConfig.getPackageType();
        DevRepackager repackager = null;
        if ("zip".equalsIgnoreCase(packageType)) {
            repackager = new ZipProdRepackager(this.repackageMojo, this.prodConfig);
        } else if ("jar".equalsIgnoreCase(packageType)) {
            repackager = new JarNestedProdRepackager(this.repackageMojo, this.prodConfig);
        } else if ("zip-outer".equalsIgnoreCase(packageType)) {
            repackager = new ZipOuterProdRepackager(this.repackageMojo, this.prodConfig);
        } else if ("jar-outer".equalsIgnoreCase(packageType)) {
            repackager = new JarOuterProdRepackager(this.repackageMojo, this.prodConfig);
        } else if ("dir".equalsIgnoreCase(packageType)) {
            repackager = new DirProdRepackager(this.repackageMojo, this.prodConfig);
        } else {
            throw new MojoFailureException("Not found packageType : " + packageType);
        }
        repackager.repackage();
    }

    protected ProdConfig getProdConfig(RepackageMojo repackageMojo) {
        String outputDirectory;
        String fileName;
        ProdConfig prodConfig = repackageMojo.getProdConfig();
        if (prodConfig == null) {
            prodConfig = new ProdConfig();
        }
        if (ObjectUtils.isEmpty((CharSequence)prodConfig.getPackageType())) {
            prodConfig.setPackageType("jar");
        }
        if (ObjectUtils.isEmpty((CharSequence)(fileName = prodConfig.getFileName()))) {
            PluginInfo pluginInfo = repackageMojo.getPluginInfo();
            prodConfig.setFileName(pluginInfo.getId() + "-" + pluginInfo.getVersion() + "-repackage");
        }
        if (ObjectUtils.isEmpty((CharSequence)(outputDirectory = prodConfig.getOutputDirectory()))) {
            prodConfig.setOutputDirectory(repackageMojo.getOutputDirectory().getPath());
        }
        return prodConfig;
    }

    public ProdConfig getProdConfig() {
        return this.prodConfig;
    }
}

