/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.prod;

import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.prod.DirProdRepackager;
import com.gitee.starblues.plugin.pack.prod.ProdConfig;
import com.gitee.starblues.plugin.pack.utils.PackageZip;
import java.io.Closeable;
import java.io.File;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ZipOuterProdRepackager
extends DirProdRepackager {
    protected PackageZip packageZip;

    public ZipOuterProdRepackager(RepackageMojo repackageMojo, ProdConfig prodConfig) {
        super(repackageMojo, prodConfig);
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            super.repackage();
        }
        catch (Exception e) {
            throw new MojoFailureException((Throwable)e);
        }
        finally {
            if (this.packageZip != null) {
                IOUtils.closeQuietly((Closeable)this.packageZip);
            }
        }
    }

    @Override
    protected String createRootDir() throws MojoFailureException {
        String rootDir = super.createRootDir();
        try {
            this.packageZip = this.getPackageZip(rootDir);
            return rootDir;
        }
        catch (Exception e) {
            throw new MojoFailureException((Throwable)e);
        }
    }

    protected PackageZip getPackageZip(String rootDir) throws Exception {
        return new PackageZip(rootDir, this.prodConfig.getFileName());
    }

    @Override
    protected void resolveClasses() throws Exception {
        String buildDir = this.repackageMojo.getProject().getBuild().getOutputDirectory();
        this.packageZip.copyDirToPackage(new File(buildDir), "");
    }

    @Override
    protected Manifest getManifest() throws Exception {
        Manifest manifest = super.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Plugin-Meta-Path", "META-INF/PLUGIN.META");
        attributes.putValue("Plugin-Package-Type", "zip-outer");
        return manifest;
    }

    @Override
    protected Properties createPluginMetaInfo() throws Exception {
        Properties properties = super.createPluginMetaInfo();
        properties.put("plugin.system.path", this.packageZip.getFileName());
        return properties;
    }
}

