/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.prod;

import com.gitee.starblues.plugin.pack.Constant;
import com.gitee.starblues.plugin.pack.RepackageMojo;
import com.gitee.starblues.plugin.pack.dev.Dependency;
import com.gitee.starblues.plugin.pack.dev.DevConfig;
import com.gitee.starblues.plugin.pack.dev.DevRepackager;
import com.gitee.starblues.plugin.pack.prod.ProdConfig;
import com.gitee.starblues.plugin.pack.utils.PackageZip;
import com.gitee.starblues.utils.FilesUtils;
import com.gitee.starblues.utils.ObjectUtils;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class ZipProdRepackager
extends DevRepackager {
    protected final ProdConfig prodConfig;
    protected PackageZip packageZip;

    public ZipProdRepackager(RepackageMojo repackageMojo, ProdConfig prodConfig) {
        super(repackageMojo);
        this.prodConfig = prodConfig;
    }

    @Override
    public void repackage() throws MojoExecutionException, MojoFailureException {
        try {
            this.packageZip = this.getPackageZip();
            super.repackage();
            this.resolveClasses();
            this.resolveResourcesDefine();
            String rootDir = this.getRootDir();
            try {
                FileUtils.deleteDirectory((File)new File(rootDir));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.repackageMojo.getLog().info((CharSequence)("Success package prod zip file : " + this.packageZip.getFile().getPath()));
        }
        catch (Exception e) {
            this.repackageMojo.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoFailureException((Throwable)e);
        }
        finally {
            if (this.packageZip != null) {
                IOUtils.closeQuietly((Closeable)this.packageZip);
            }
        }
    }

    protected PackageZip getPackageZip() throws Exception {
        return new PackageZip(this.prodConfig.getOutputDirectory(), this.prodConfig.getFileName());
    }

    @Override
    protected String getBasicRootDir() {
        File outputDirectory = this.repackageMojo.getOutputDirectory();
        return FilesUtils.joiningFilePath((String[])new String[]{outputDirectory.getPath(), UUID.randomUUID().toString()});
    }

    @Override
    protected Map<String, Dependency> getModuleDependencies(DevConfig devConfig) {
        return Collections.emptyMap();
    }

    @Override
    protected String getPluginPath() {
        return "classes/";
    }

    @Override
    protected String getLibIndex(Artifact artifact) {
        return "lib/" + artifact.getFile().getName() + this.repackageMojo.resolveLoadToMain(artifact);
    }

    @Override
    protected boolean filterArtifact(Artifact artifact) {
        return Constant.scopeFilter(artifact.getScope());
    }

    protected void resolveClasses() throws Exception {
        String buildDir = this.repackageMojo.getProject().getBuild().getOutputDirectory();
        this.packageZip.copyDirToPackage(new File(buildDir), null);
    }

    @Override
    protected Manifest getManifest() throws Exception {
        Manifest manifest = super.getManifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.putValue("Plugin-Meta-Path", "META-INF/PLUGIN.META");
        attributes.putValue("Plugin-Package-Type", "zip");
        return manifest;
    }

    @Override
    protected Properties createPluginMetaInfo() throws Exception {
        Properties properties = super.createPluginMetaInfo();
        properties.put("plugin.system.resourcesConfig", "META-INF/RESOURCES.CONF");
        return properties;
    }

    @Override
    protected void writeManifest(Manifest manifest) throws Exception {
        this.packageZip.writeManifest(manifest);
    }

    @Override
    protected String writePluginMetaInfo(Properties properties) throws Exception {
        this.packageZip.write("META-INF/PLUGIN.META", outputStream -> properties.store(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8), "plugin meta configuration"));
        return "META-INF/PLUGIN.META";
    }

    protected void resolveResourcesDefine() throws Exception {
        Set<String> dependencyIndexNames = this.resolveDependencies();
        StringBuilder content = new StringBuilder();
        content.append("dependencies.index").append("\n");
        for (String dependencyIndexName : dependencyIndexNames) {
            content.append(dependencyIndexName).append("\n");
        }
        String loadMainResources = super.getLoadMainResources();
        if (!ObjectUtils.isEmpty((CharSequence)loadMainResources)) {
            content.append(loadMainResources).append("\n");
        }
        byte[] bytes = content.toString().getBytes(StandardCharsets.UTF_8);
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);){
            this.packageZip.putInputStreamEntry("META-INF/RESOURCES.CONF", byteArrayInputStream);
        }
    }

    protected Set<String> resolveDependencies() throws Exception {
        Set<Artifact> dependencies = this.repackageMojo.getFilterDependencies();
        String libDirEntryName = this.createLibEntry();
        HashSet<String> dependencyIndexNames = new HashSet<String>(dependencies.size());
        for (Artifact artifact : dependencies) {
            if (this.filterArtifact(artifact)) continue;
            String dependencyIndexName = this.packageZip.writeDependency(artifact.getFile(), libDirEntryName);
            dependencyIndexNames.add(dependencyIndexName);
        }
        return dependencyIndexNames;
    }

    protected String createLibEntry() throws Exception {
        String libDirEntryName = "lib/";
        this.packageZip.putDirEntry(libDirEntryName);
        return libDirEntryName;
    }
}

