/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.plugin.pack.utils;

import com.gitee.starblues.utils.FilesUtils;
import com.gitee.starblues.utils.ObjectUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class PackageZip
implements Closeable {
    private static final int UNIX_FILE_MODE = 33188;
    private static final int UNIX_DIR_MODE = 16877;
    private final File file;
    private final ArchiveOutputStream outputStream;

    public PackageZip(File file) throws Exception {
        this.file = file;
        this.outputStream = this.getOutputStream(file);
    }

    public PackageZip(String outputDirectory, String packageName) throws Exception {
        String rootPath = FilesUtils.joiningFilePath((String[])new String[]{outputDirectory, packageName});
        this.file = this.getPackageFile(rootPath);
        this.outputStream = this.getOutputStream(this.file);
    }

    public File getFile() {
        return this.file;
    }

    public String getFileName() {
        return this.file.getName();
    }

    protected File getPackageFile(String rootPath) throws Exception {
        String fileSuffix = this.getPackageFileSuffix();
        File file = new File(rootPath + "." + fileSuffix);
        if (file.exists()) {
            int i = 0;
            while ((file = new File(rootPath + "_" + i + "." + fileSuffix)).exists()) {
                ++i;
            }
        }
        if (file.createNewFile()) {
            return file;
        }
        throw new IOException("Create file '" + file.getPath() + "' failure.");
    }

    protected String getPackageFileSuffix() {
        return "zip";
    }

    protected ArchiveOutputStream getOutputStream(File packFile) throws Exception {
        return new ZipArchiveOutputStream((OutputStream)new FileOutputStream(packFile));
    }

    public void copyDirToPackage(File rootDir, String packageDir) throws Exception {
        if (packageDir == null) {
            packageDir = rootDir.getName();
        }
        if (rootDir.isDirectory()) {
            File[] childFiles = rootDir.listFiles();
            if (ObjectUtils.isEmpty((CharSequence)packageDir)) {
                packageDir = "";
            } else {
                packageDir = packageDir + "/";
                this.putDirEntry(packageDir);
            }
            if (childFiles == null) {
                return;
            }
            for (File childFile : childFiles) {
                this.copyDirToPackage(childFile, packageDir + childFile.getName());
            }
        } else {
            this.putFileEntry(rootDir, packageDir);
        }
    }

    public void copyZipToPackage(File sourceZipFile) throws Exception {
        if (sourceZipFile == null || !sourceZipFile.exists()) {
            return;
        }
        try (ZipFile zipFile = new ZipFile(sourceZipFile);){
            Enumeration entries = zipFile.getEntries();
            while (entries.hasMoreElements()) {
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entries.nextElement();
                String name = zipArchiveEntry.getName();
                if (name.contains("META-INF")) continue;
                if (zipArchiveEntry.isDirectory()) {
                    this.putDirEntry(name);
                    continue;
                }
                InputStream inputStream = zipFile.getInputStream(zipArchiveEntry);
                try {
                    this.putInputStreamEntry(name, inputStream);
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
        }
    }

    public String writeDependency(File dependencyFile, String libDirEntryName) throws Exception {
        String indexName = libDirEntryName + dependencyFile.getName();
        ZipArchiveEntry entry = this.getArchiveEntry(indexName);
        entry.setTime(System.currentTimeMillis());
        entry.setUnixMode(indexName.endsWith("/") ? 16877 : 33188);
        entry.getGeneralPurposeBit().useUTF8ForNames(true);
        try (FileInputStream inputStream = new FileInputStream(dependencyFile);){
            new CrcAndSize(inputStream).setupStoredEntry(entry);
        }
        inputStream = new FileInputStream(dependencyFile);
        try {
            this.outputStream.putArchiveEntry((ArchiveEntry)entry);
            IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
            this.outputStream.closeArchiveEntry();
        }
        finally {
            inputStream.close();
        }
        return indexName;
    }

    public void putFileEntry(File destFile, String rootDir) throws Exception {
        if (!destFile.exists()) {
            throw new FileNotFoundException("Not found file : " + destFile.getPath());
        }
        this.outputStream.putArchiveEntry((ArchiveEntry)this.getArchiveEntry(rootDir));
        FileUtils.copyFile((File)destFile, (OutputStream)this.outputStream);
        this.outputStream.closeArchiveEntry();
    }

    public void putInputStreamEntry(String name, InputStream inputStream) throws Exception {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.getArchiveEntry(name));
        IOUtils.copy((InputStream)inputStream, (OutputStream)this.outputStream);
        this.outputStream.closeArchiveEntry();
    }

    public void write(String name, Writer writer) throws Exception {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.getArchiveEntry(name));
        writer.write(this.outputStream);
        this.outputStream.closeArchiveEntry();
    }

    public void write(String name, File file) throws Exception {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.getArchiveEntry(name));
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            IOUtils.copy((InputStream)fileInputStream, (OutputStream)this.outputStream);
            this.outputStream.closeArchiveEntry();
        }
    }

    public void writeManifest(Manifest manifest) throws Exception {
        this.putDirEntry("META-INF/");
        this.write("META-INF/MANIFEST.MF", manifest::write);
    }

    public void putDirEntry(String dir) throws IOException {
        this.outputStream.putArchiveEntry((ArchiveEntry)this.getArchiveEntry(dir));
        this.outputStream.closeArchiveEntry();
    }

    protected ZipArchiveEntry getArchiveEntry(String name) {
        return new ZipArchiveEntry(name);
    }

    @Override
    public void close() throws IOException {
        this.outputStream.finish();
        this.outputStream.close();
    }

    @FunctionalInterface
    public static interface Writer {
        public void write(ArchiveOutputStream var1) throws Exception;
    }

    private static class CrcAndSize {
        private static final int BUFFER_SIZE = 32768;
        private final CRC32 crc = new CRC32();
        private long size;

        CrcAndSize(InputStream inputStream) throws IOException {
            this.load(inputStream);
        }

        private void load(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buffer = new byte[32768];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                this.crc.update(buffer, 0, bytesRead);
                this.size += (long)bytesRead;
            }
        }

        void setupStoredEntry(ZipArchiveEntry entry) {
            entry.setSize(this.size);
            entry.setCompressedSize(this.size);
            entry.setCrc(this.crc.getValue());
            entry.setMethod(0);
        }
    }
}

