/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.common.executor;

import java.io.IOException;
import java.io.InputStream;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.executor.CommonUploadRequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.hc.Utf8ResponseHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;

public class CommonUploadRequestExecutorHttpComponentsImpl
extends CommonUploadRequestExecutor<CloseableHttpClient, HttpHost> {
    public CommonUploadRequestExecutorHttpComponentsImpl(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    @Override
    public String execute(String uri, CommonUploadParam param, WxType wxType) throws WxErrorException, IOException {
        String responseContent;
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (param != null) {
            CommonUploadData data = param.getData();
            InnerStreamBody part = new InnerStreamBody(data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFileName(), data.getLength());
            HttpEntity entity = MultipartEntityBuilder.create().addPart(param.getName(), (ContentBody)part).setMode(HttpMultipartMode.EXTENDED).build();
            httpPost.setEntity(entity);
        }
        if (StringUtils.isEmpty((CharSequence)(responseContent = (String)((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((ClassicHttpRequest)httpPost, Utf8ResponseHandler.INSTANCE)))) {
            throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
        }
        WxError error = WxError.fromJson(responseContent, wxType);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return responseContent;
    }

    public static class InnerStreamBody
    extends InputStreamBody {
        private final long contentLength;

        public InnerStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
            super(in, contentType, filename);
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

