/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaShopSharerService;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSearchSharerResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerBindResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerDataSummaryResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerLiveOrderListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerLiveSummaryListResponse;
import cn.binarywang.wx.miniapp.bean.shop.response.WxMaShopSharerUnbindResponse;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.JsonObject;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonHelper;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxMaShopSharerServiceImpl
implements WxMaShopSharerService {
    private static final Logger log = LoggerFactory.getLogger(WxMaShopSharerServiceImpl.class);
    private final WxMaService wxMaService;

    @Override
    public WxMaShopSharerBindResponse bindSharer(String[] openids) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openids", openids});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/bind", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerBindResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerBindResponse.class);
    }

    @Override
    public WxMaShopSharerDataSummaryResponse getSharerDataSummary(String openid) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/get_sharer_data_summary", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerDataSummaryResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerDataSummaryResponse.class);
    }

    @Override
    public WxMaShopSharerListResponse getSharerList(Integer page, Integer pageSize) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"page", page, "page_size", pageSize});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/get_sharer_list", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerListResponse.class);
    }

    @Override
    public WxMaShopSharerLiveOrderListResponse getSharerLiveOrderList(String openid, String liveExportId, Integer page, Integer pageSize) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid, "live_export_id", liveExportId, "page", page, "page_size", pageSize});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/get_sharer_live_order_list", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerLiveOrderListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerLiveOrderListResponse.class);
    }

    @Override
    public WxMaShopSharerLiveSummaryListResponse getSharerLiveSummaryList(String openid, Integer page, Integer pageSize) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid, "page", page, "page_size", pageSize});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/get_sharer_live_summary_list", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerLiveSummaryListResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerLiveSummaryListResponse.class);
    }

    @Override
    public WxMaShopSearchSharerResponse searchSharer(String openid) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openid", openid});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/search_sharer", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSearchSharerResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSearchSharerResponse.class);
    }

    @Override
    public WxMaShopSharerUnbindResponse unbindSharer(String[] openids) throws WxErrorException {
        JsonObject json = GsonHelper.buildJsonObject((Object[])new Object[]{"openids", openids});
        String responseContent = this.wxMaService.post("https://api.weixin.qq.com/shop/sharer/unbind", json);
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
        return (WxMaShopSharerUnbindResponse)WxMaGsonBuilder.create().fromJson(responseContent, WxMaShopSharerUnbindResponse.class);
    }

    public WxMaShopSharerServiceImpl(WxMaService wxMaService) {
        this.wxMaService = wxMaService;
    }
}

