/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaSubscribeService;
import cn.binarywang.wx.miniapp.bean.WxMaSubscribeMessage;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.bean.subscribemsg.CategoryData;
import me.chanjar.weixin.common.bean.subscribemsg.PubTemplateKeyword;
import me.chanjar.weixin.common.bean.subscribemsg.PubTemplateTitleListResult;
import me.chanjar.weixin.common.bean.subscribemsg.TemplateInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.json.GsonParser;
import org.apache.commons.lang3.StringUtils;

public class WxMaSubscribeServiceImpl
implements WxMaSubscribeService {
    private final WxMaService service;

    @Override
    public PubTemplateTitleListResult getPubTemplateTitleList(String[] ids, int start, int limit) throws WxErrorException {
        ImmutableMap params = ImmutableMap.of((Object)"ids", (Object)StringUtils.join((Object[])ids, (String)","), (Object)"start", (Object)start, (Object)"limit", (Object)limit);
        String responseText = this.service.get("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatetitles", Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)params));
        return PubTemplateTitleListResult.fromJson((String)responseText);
    }

    @Override
    public List<PubTemplateKeyword> getPubTemplateKeyWordsById(String id) throws WxErrorException {
        String responseText = this.service.get("https://api.weixin.qq.com/wxaapi/newtmpl/getpubtemplatekeywords", Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)ImmutableMap.of((Object)"tid", (Object)id)));
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<PubTemplateKeyword>>(){}.getType());
    }

    @Override
    public String addTemplate(String id, List<Integer> keywordIdList, String sceneDesc) throws WxErrorException {
        String responseText = this.service.post("https://api.weixin.qq.com/wxaapi/newtmpl/addtemplate", ImmutableMap.of((Object)"tid", (Object)id, (Object)"kidList", (Object)keywordIdList.toArray(), (Object)"sceneDesc", (Object)sceneDesc));
        return GsonParser.parse((String)responseText).get("priTmplId").getAsString();
    }

    @Override
    public List<TemplateInfo> getTemplateList() throws WxErrorException {
        String responseText = this.service.get("https://api.weixin.qq.com/wxaapi/newtmpl/gettemplate", null);
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<TemplateInfo>>(){}.getType());
    }

    @Override
    public boolean delTemplate(String templateId) throws WxErrorException {
        this.service.post("https://api.weixin.qq.com/wxaapi/newtmpl/deltemplate", ImmutableMap.of((Object)"priTmplId", (Object)templateId));
        return true;
    }

    @Override
    public List<CategoryData> getCategory() throws WxErrorException {
        String responseText = this.service.get("https://api.weixin.qq.com/wxaapi/newtmpl/getcategory", null);
        return (List)WxMaGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<CategoryData>>(){}.getType());
    }

    @Override
    public void sendSubscribeMsg(WxMaSubscribeMessage subscribeMessage) throws WxErrorException {
        String responseContent = this.service.post("https://api.weixin.qq.com/cgi-bin/message/subscribe/send", subscribeMessage.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MiniApp));
        }
    }

    public WxMaSubscribeServiceImpl(WxMaService service) {
        this.service = service;
    }
}

