/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import java.io.IOException;
import me.chanjar.weixin.common.util.http.HttpClientType;
import me.chanjar.weixin.common.util.http.hc.BasicResponseHandler;
import me.chanjar.weixin.common.util.http.hc.DefaultHttpComponentsClientBuilder;
import me.chanjar.weixin.mp.api.impl.BaseWxMpServiceImpl;
import me.chanjar.weixin.mp.bean.WxMpStableAccessTokenRequest;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class WxMpServiceHttpComponentsImpl
extends BaseWxMpServiceImpl<CloseableHttpClient, HttpHost> {
    private CloseableHttpClient httpClient;
    private HttpHost httpProxy;

    public CloseableHttpClient getRequestHttpClient() {
        return this.httpClient;
    }

    public HttpHost getRequestHttpProxy() {
        return this.httpProxy;
    }

    public HttpClientType getRequestType() {
        return HttpClientType.HTTP_COMPONENTS;
    }

    @Override
    public void initHttp() {
        WxMpConfigStorage configStorage = this.getWxMpConfigStorage();
        DefaultHttpComponentsClientBuilder apacheHttpClientBuilder = DefaultHttpComponentsClientBuilder.get();
        apacheHttpClientBuilder.httpProxyHost(configStorage.getHttpProxyHost()).httpProxyPort(configStorage.getHttpProxyPort()).httpProxyUsername(configStorage.getHttpProxyUsername()).httpProxyPassword(configStorage.getHttpProxyPassword().toCharArray());
        if (configStorage.getHttpProxyHost() != null && configStorage.getHttpProxyPort() > 0) {
            this.httpProxy = new HttpHost(configStorage.getHttpProxyHost(), configStorage.getHttpProxyPort());
        }
        this.httpClient = apacheHttpClientBuilder.build();
    }

    @Override
    protected String doGetAccessTokenRequest() throws IOException {
        String url = String.format(WxMpApiUrl.Other.GET_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage()), this.getWxMpConfigStorage().getAppId(), this.getWxMpConfigStorage().getSecret());
        HttpGet httpGet = new HttpGet(url);
        if (this.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
            httpGet.setConfig(config);
        }
        return (String)this.getRequestHttpClient().execute((ClassicHttpRequest)httpGet, (HttpClientResponseHandler)BasicResponseHandler.INSTANCE);
    }

    @Override
    protected String doGetStableAccessTokenRequest(boolean forceRefresh) throws IOException {
        String url = WxMpApiUrl.Other.GET_STABLE_ACCESS_TOKEN_URL.getUrl(this.getWxMpConfigStorage());
        HttpPost httpPost = new HttpPost(url);
        if (this.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy(this.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        WxMpStableAccessTokenRequest wxMaAccessTokenRequest = new WxMpStableAccessTokenRequest();
        wxMaAccessTokenRequest.setAppid(this.getWxMpConfigStorage().getAppId());
        wxMaAccessTokenRequest.setSecret(this.getWxMpConfigStorage().getSecret());
        wxMaAccessTokenRequest.setGrantType("client_credential");
        wxMaAccessTokenRequest.setForceRefresh(forceRefresh);
        httpPost.setEntity((HttpEntity)new StringEntity(wxMaAccessTokenRequest.toJson(), ContentType.APPLICATION_JSON));
        return (String)this.getRequestHttpClient().execute((ClassicHttpRequest)httpPost, (HttpClientResponseHandler)BasicResponseHandler.INSTANCE);
    }
}

