/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.mp.api.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.bean.subscribemsg.CategoryData;
import me.chanjar.weixin.common.bean.subscribemsg.PubTemplateKeyword;
import me.chanjar.weixin.common.bean.subscribemsg.PubTemplateTitleListResult;
import me.chanjar.weixin.common.bean.subscribemsg.TemplateInfo;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.URIUtil;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.WxMpSubscribeMsgService;
import me.chanjar.weixin.mp.bean.subscribe.WxMpSubscribeMessage;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import me.chanjar.weixin.mp.enums.WxMpApiUrl;
import me.chanjar.weixin.mp.util.json.WxMpGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class WxMpSubscribeMsgServiceImpl
implements WxMpSubscribeMsgService {
    private final WxMpService service;

    @Override
    public String subscribeMsgAuthorizationUrl(String redirectUri, int scene, String reserved) {
        WxMpConfigStorage storage = this.service.getWxMpConfigStorage();
        return String.format(WxMpApiUrl.SubscribeMsg.SUBSCRIBE_MESSAGE_AUTHORIZE_URL.getUrl(storage), storage.getAppId(), scene, storage.getTemplateId(), URIUtil.encodeURIComponent((String)redirectUri), reserved);
    }

    @Override
    public boolean sendOnce(WxMpSubscribeMessage message) throws WxErrorException {
        String responseContent;
        if (message.getTemplateId() == null) {
            message.setTemplateId(this.service.getWxMpConfigStorage().getTemplateId());
        }
        return (responseContent = this.service.post((WxMpApiUrl)WxMpApiUrl.SubscribeMsg.SEND_MESSAGE_ONCE_URL, message.toJson())) != null;
    }

    @Override
    public PubTemplateTitleListResult getPubTemplateTitleList(String[] ids, int start, int limit) throws WxErrorException {
        ImmutableMap params = ImmutableMap.of((Object)"ids", (Object)StringUtils.join((Object[])ids, (String)","), (Object)"start", (Object)start, (Object)"limit", (Object)limit);
        String responseText = this.service.get(WxMpApiUrl.SubscribeMsg.GET_PUB_TEMPLATE_TITLE_LIST_URL, Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)params));
        return PubTemplateTitleListResult.fromJson((String)responseText);
    }

    @Override
    public List<PubTemplateKeyword> getPubTemplateKeyWordsById(String id) throws WxErrorException {
        String responseText = this.service.get(WxMpApiUrl.SubscribeMsg.GET_PUB_TEMPLATE_KEY_WORDS_BY_ID_URL, Joiner.on((String)"&").withKeyValueSeparator("=").join((Map)ImmutableMap.of((Object)"tid", (Object)id)));
        return (List)WxMpGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<PubTemplateKeyword>>(){}.getType());
    }

    @Override
    public String addTemplate(String id, List<Integer> keywordIdList, String sceneDesc) throws WxErrorException {
        String responseText = this.service.post((WxMpApiUrl)WxMpApiUrl.SubscribeMsg.TEMPLATE_ADD_URL, ImmutableMap.of((Object)"tid", (Object)id, (Object)"kidList", (Object)keywordIdList.toArray(), (Object)"sceneDesc", (Object)sceneDesc));
        return GsonParser.parse((String)responseText).get("priTmplId").getAsString();
    }

    @Override
    public List<TemplateInfo> getTemplateList() throws WxErrorException {
        String responseText = this.service.get(WxMpApiUrl.SubscribeMsg.TEMPLATE_LIST_URL, null);
        return (List)WxMpGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<TemplateInfo>>(){}.getType());
    }

    @Override
    public boolean delTemplate(String templateId) throws WxErrorException {
        this.service.post((WxMpApiUrl)WxMpApiUrl.SubscribeMsg.TEMPLATE_DEL_URL, ImmutableMap.of((Object)"priTmplId", (Object)templateId));
        return true;
    }

    @Override
    public List<CategoryData> getCategory() throws WxErrorException {
        String responseText = this.service.get(WxMpApiUrl.SubscribeMsg.GET_CATEGORY_URL, null);
        return (List)WxMpGsonBuilder.create().fromJson((JsonElement)GsonParser.parse((String)responseText).getAsJsonArray("data"), new TypeToken<List<CategoryData>>(){}.getType());
    }

    @Override
    public String send(WxMpSubscribeMessage subscribeMessage) throws WxErrorException {
        String responseContent = this.service.post((WxMpApiUrl)WxMpApiUrl.SubscribeMsg.SEND_SUBSCRIBE_MESSAGE_URL, subscribeMessage.toJson());
        JsonObject jsonObject = GsonParser.parse((String)responseContent);
        if (jsonObject.get("errcode").getAsInt() != 0) {
            throw new WxErrorException(WxError.fromJson((String)responseContent, (WxType)WxType.MP));
        }
        return jsonObject.get("msgid").getAsString();
    }

    public WxMpSubscribeMsgServiceImpl(WxMpService service) {
        this.service = service;
    }
}

