/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.constant;

import com.github.binarywang.wxpay.bean.order.WxPayAppOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMpOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayMwebOrderResult;
import com.github.binarywang.wxpay.bean.order.WxPayNativeOrderResult;
import com.github.binarywang.wxpay.bean.result.WxPayMicropayResult;
import com.google.common.collect.Lists;
import java.text.Format;
import java.util.List;
import org.apache.commons.lang3.time.FastDateFormat;

public class WxPayConstants {
    public static final Format QUERY_COMMENT_DATE_FORMAT = FastDateFormat.getInstance((String)"yyyyMMddHHmmss");

    public static final class UserRecvPerception {
        private UserRecvPerception() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }

        public static class CASH_MARKETING {
            public static final String ACTIVITY = "\u6d3b\u52a8\u5956\u52b1";
            public static final String CASH = "\u73b0\u91d1\u5956\u52b1";
        }
    }

    public static final class TransformSceneId {
        public static final String CASH_MARKETING = "1001";

        private TransformSceneId() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static final class TransformBillState {
        public static final String ACCEPTED = "ACCEPTED";
        public static final String PROCESSING = "PROCESSING";
        public static final String WAIT_USER_CONFIRM = "WAIT_USER_CONFIRM";
        public static final String TRANSFERING = "TRANSFERING";
        public static final String SUCCESS = "SUCCESS";
        public static final String FAIL = "FAIL";
        public static final String CANCELING = "CANCELING";
        public static final String CANCELLED = "CANCELLED";

        private TransformBillState() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }

    public static class ReceiverType {
        public static final String MERCHANT_ID = "MERCHANT_ID";
        public static final String PERSONAL_WECHATID = "PERSONAL_WECHATID";
        public static final String PERSONAL_OPENID = "PERSONAL_OPENID";
        public static final String PERSONAL_SUB_OPENID = "PERSONAL_SUB_OPENID";
    }

    public static class RefundStatus {
        public static final String SUCCESS = "SUCCESS";
        public static final String REFUND_CLOSE = "REFUNDCLOSE";
        public static final String PROCESSING = "PROCESSING";
        public static final String CHANGE = "CHANGE";
        public static final String CLOSED = "CLOSED";
        public static final String ABNORMAL = "ABNORMAL";
    }

    public static class WxpayTradeStatus {
        public static final String SUCCESS = "SUCCESS";
        public static final String PAY_ERROR = "PAYERROR";
        public static final String USER_PAYING = "USERPAYING";
        public static final String CLOSED = "CLOSED";
        public static final String NOTPAY = "NOTPAY";
        public static final String REFUND = "REFUND";
        public static final String REVOKED = "REVOKED";
    }

    public static class RefundChannel {
        public static final String ORIGINAL = "ORIGINAL";
        public static final String BALANCE = "BALANCE";
        public static final String OTHER_BALANCE = "OTHER_BALANCE";
        public static final String OTHER_BANKCARD = "OTHER_BANKCARD";
    }

    public static class RefundAccountSource {
        public static final String RECHARGE_FUNDS = "REFUND_SOURCE_RECHARGE_FUNDS";
        public static final String UNSETTLED_FUNDS = "REFUND_SOURCE_UNSETTLED_FUNDS";
    }

    public static class ResultCode {
        public static final String SUCCESS = "SUCCESS";
        public static final String FAIL = "FAIL";
    }

    public static class LimitPay {
        public static final String NO_CREDIT = "no_credit";
    }

    public static class SignType {
        public static final String HMAC_SHA256 = "HMAC-SHA256";
        public static final String MD5 = "MD5";
        public static final List<String> ALL_SIGN_TYPES = Lists.newArrayList((Object[])new String[]{"HMAC-SHA256", "MD5"});
    }

    public static class TradeType {
        public static final String NATIVE = "NATIVE";
        public static final String APP = "APP";
        public static final String JSAPI = "JSAPI";
        public static final String MWEB = "MWEB";
        public static final String MICROPAY = "MICROPAY";

        public static abstract class Specific<R> {
            public static Specific<WxPayNativeOrderResult> NATIVE = new Specific<WxPayNativeOrderResult>(){

                @Override
                public String getType() {
                    return TradeType.NATIVE;
                }
            };
            public static Specific<WxPayAppOrderResult> APP = new Specific<WxPayAppOrderResult>(){

                @Override
                public String getType() {
                    return TradeType.APP;
                }
            };
            public static Specific<WxPayMpOrderResult> JSAPI = new Specific<WxPayMpOrderResult>(){

                @Override
                public String getType() {
                    return TradeType.JSAPI;
                }
            };
            public static Specific<WxPayMwebOrderResult> MWEB = new Specific<WxPayMwebOrderResult>(){

                @Override
                public String getType() {
                    return TradeType.MWEB;
                }
            };
            public static Specific<WxPayMicropayResult> MICROPAY = new Specific<WxPayMicropayResult>(){

                @Override
                public String getType() {
                    return TradeType.MICROPAY;
                }
            };

            public abstract String getType();

            private Specific() {
            }
        }
    }

    public static class BillType {
        public static final String MCHT = "MCHT";
        public static final String ALL = "ALL";
        public static final String SUCCESS = "SUCCESS";
        public static final String REFUND = "REFUND";
        public static final String RECHARGE_REFUND = "RECHARGE_REFUND";
    }

    public static class TarType {
        public static final String GZIP = "GZIP";
    }

    public static class CheckNameOption {
        public static final String NO_CHECK = "NO_CHECK";
        public static final String FORCE_CHECK = "FORCE_CHECK";
    }

    public static class CurrencyType {
        public static final String CNY = "CNY";
    }
}

