/*
 * Decompiled with CFR 0.152.
 */
package com.binarywang.spring.starter.wxjava.mp.config;

import com.binarywang.spring.starter.wxjava.mp.enums.HttpClientType;
import com.binarywang.spring.starter.wxjava.mp.properties.WxMpProperties;
import me.chanjar.weixin.mp.api.WxMpService;
import me.chanjar.weixin.mp.api.impl.WxMpServiceHttpClientImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceJoddHttpImpl;
import me.chanjar.weixin.mp.api.impl.WxMpServiceOkHttpImpl;
import me.chanjar.weixin.mp.config.WxMpConfigStorage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WxMpServiceAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public WxMpService wxMpService(WxMpConfigStorage configStorage, WxMpProperties wxMpProperties) {
        WxMpService wxMpService;
        HttpClientType httpClientType = wxMpProperties.getConfigStorage().getHttpClientType();
        switch (httpClientType) {
            case OkHttp: {
                wxMpService = this.newWxMpServiceOkHttpImpl();
                break;
            }
            case JoddHttp: {
                wxMpService = this.newWxMpServiceJoddHttpImpl();
                break;
            }
            case HttpClient: {
                wxMpService = this.newWxMpServiceHttpClientImpl();
                break;
            }
            default: {
                wxMpService = this.newWxMpServiceImpl();
            }
        }
        wxMpService.setWxMpConfigStorage(configStorage);
        return wxMpService;
    }

    private WxMpService newWxMpServiceImpl() {
        return new WxMpServiceImpl();
    }

    private WxMpService newWxMpServiceHttpClientImpl() {
        return new WxMpServiceHttpClientImpl();
    }

    private WxMpService newWxMpServiceOkHttpImpl() {
        return new WxMpServiceOkHttpImpl();
    }

    private WxMpService newWxMpServiceJoddHttpImpl() {
        return new WxMpServiceJoddHttpImpl();
    }
}

