/*
 * Decompiled with CFR 0.152.
 */
package com.fastobject.diff;

import com.fastobject.diff.DiffLog;
import com.fastobject.diff.DiffLogKey;
import com.fastobject.diff.DiffUtils;
import com.fastobject.diff.DiffWapper;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractObjectDiff {
    protected abstract String genDiffStr(Object var1, Object var2) throws Exception;

    public static String genChineseDiffStr(Object sourceObject, Object targetObject) throws Exception {
        List<DiffWapper> diffWappers = AbstractObjectDiff.generateDiff(sourceObject, targetObject);
        return DiffUtils.genDiffStr(diffWappers);
    }

    public static List<DiffWapper> generateDiff(Object sourceObject, Object targetObject) throws Exception {
        return AbstractObjectDiff.generateDiff("", "", sourceObject, targetObject);
    }

    private static List<DiffWapper> generateDiff(String path, String cnName, Object sourceObject, Object targetObject) throws Exception {
        ArrayList<DiffWapper> diffWappers = new ArrayList<DiffWapper>();
        if (sourceObject == null && targetObject == null) {
            return null;
        }
        if (sourceObject == null || targetObject == null) {
            DiffWapper diffWapper = DiffUtils.getDiffWapper(path, cnName, sourceObject == null ? null : AbstractObjectDiff.getObjectString(sourceObject), targetObject == null ? null : AbstractObjectDiff.getObjectString(targetObject));
            diffWappers.add(diffWapper);
            return diffWappers;
        }
        if (!sourceObject.getClass().getName().equals(targetObject.getClass().getName())) {
            return null;
        }
        if (sourceObject.hashCode() == targetObject.hashCode()) {
            return null;
        }
        Field[] fields = sourceObject.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String newPath;
            Field field = fields[i];
            Class<?> type = field.getType();
            String nameCn = newPath = path + "/" + field.getName();
            field.setAccessible(true);
            if (!field.isAnnotationPresent(DiffLog.class)) continue;
            DiffLog logVo = field.getAnnotation(DiffLog.class);
            nameCn = cnName == null || cnName.equals("") ? logVo.name() : cnName + "." + logVo.name();
            if (logVo.ignore()) continue;
            if (Collection.class.isAssignableFrom(type)) {
                List oldList = (List)field.get(sourceObject);
                List newList = (List)field.get(targetObject);
                HashMap oldFilterMap = new HashMap();
                HashMap newFilterMap = new HashMap();
                Field[] collFields = oldList.get(0).getClass().getDeclaredFields();
                Field keyField = null;
                String keyCnName = "";
                for (int j = 0; j < collFields.length; ++j) {
                    if (!collFields[j].isAnnotationPresent(DiffLogKey.class)) continue;
                    keyField = collFields[j];
                    DiffLogKey keyFieldAnnotation = keyField.getAnnotation(DiffLogKey.class);
                    keyCnName = keyFieldAnnotation.name();
                    break;
                }
                if (keyField == null) continue;
                keyField.setAccessible(true);
                for (Object o : newList) {
                    Object o1 = keyField.get(o);
                    newFilterMap.put(o1, o);
                }
                for (Object old : oldList) {
                    Object o2 = keyField.get(old);
                    oldFilterMap.put(o2, old);
                }
                Set oldKeySets = oldFilterMap.keySet();
                Set newKeySets = newFilterMap.keySet();
                HashSet resultSet = new HashSet();
                resultSet.clear();
                resultSet.addAll(oldKeySets);
                resultSet.addAll(newKeySets);
                for (Object result : resultSet) {
                    String oBcnName;
                    Object oldOb = oldFilterMap.get(result);
                    Object newOb = newFilterMap.get(result);
                    String oBPath = newPath + "/" + result.toString();
                    List<DiffWapper> collectDiff = AbstractObjectDiff.generateDiff(oBPath, oBcnName = nameCn + "." + keyCnName + "[" + result.toString() + "]", oldOb, newOb);
                    if (collectDiff == null) continue;
                    diffWappers.addAll(collectDiff);
                }
                continue;
            }
            DiffWapper diffWapper = AbstractObjectDiff.generateOneDiffs(newPath, nameCn, field, sourceObject, targetObject);
            if (diffWapper == null) continue;
            diffWappers.add(diffWapper);
        }
        return diffWappers;
    }

    private static DiffWapper generateOneDiffs(String path, String nameCn, Field field, Object source, Object target) throws Exception {
        DiffUtils<Object> diffUtils = new DiffUtils<Object>();
        String typeName = field.getType().getName();
        Class<?> type = field.getType();
        field.setAccessible(true);
        DiffLog logVo = field.getAnnotation(DiffLog.class);
        String dateFormat = "";
        if (logVo != null) {
            dateFormat = logVo.dateFormat();
            if (logVo.ignore()) {
                return null;
            }
        }
        if ("java.lang.String".equals(typeName)) {
            String oldStr = (String)field.get(source);
            String newStr = (String)field.get(target);
            return diffUtils.get(path, nameCn, oldStr, newStr);
        }
        if ("java.sql.Timestamp".equals(typeName)) {
            SimpleDateFormat format = new SimpleDateFormat(StringUtils.isBlank((String)dateFormat) ? "yyyy-MM-dd HH:mm:ss" : dateFormat);
            Timestamp newTime = (Timestamp)field.get(target);
            Timestamp oldTime = (Timestamp)field.get(source);
            String newTempTimeStr = "";
            String oldTimeTimeStr = "";
            if (newTime != null) {
                newTempTimeStr = format.format(newTime);
            }
            if (oldTime != null) {
                oldTimeTimeStr = format.format(oldTime);
            }
            if (oldTime == newTime && oldTime == null) {
                return null;
            }
            if (oldTime == null || newTime == null) {
                return DiffUtils.getDiffWapper(path, nameCn, oldTime == null ? null : oldTimeTimeStr, newTime == null ? null : newTempTimeStr);
            }
            if (!StringUtils.equals((String)newTempTimeStr, (String)oldTimeTimeStr)) {
                return DiffUtils.getDiffWapper(path, nameCn, format.format(oldTime), format.format(newTime));
            }
        } else {
            if ("java.lang.Long".equals(typeName) || Long.TYPE == type) {
                Long oldValue = (Long)field.get(source);
                Long newValue = (Long)field.get(target);
                return diffUtils.get(path, nameCn, oldValue, newValue);
            }
            if ("java.lang.Integer".equals(typeName) || Integer.TYPE == type) {
                Integer oldValue = (Integer)field.get(source);
                Integer newValue = (Integer)field.get(target);
                return diffUtils.get(path, nameCn, oldValue, newValue);
            }
            if ("java.lang.Boolean".equals(typeName) || Boolean.TYPE == type) {
                Boolean oldValue = field.getBoolean(source);
                Boolean newValue = field.getBoolean(target);
                return diffUtils.get(path, nameCn, oldValue, newValue);
            }
            if ("java.math.BigDecimal".equals(typeName)) {
                BigDecimal oldValue = (BigDecimal)field.get(source);
                BigDecimal newValue = (BigDecimal)field.get(target);
                if (oldValue != null && newValue != null && oldValue.compareTo(newValue) == 0) {
                    newValue = oldValue;
                }
                return diffUtils.get(path, nameCn, oldValue, newValue);
            }
            if (!"java.lang.Byte".equals(typeName) && Byte.TYPE != type && !"java.lang.Short".equals(typeName) && Short.TYPE != type) {
                if ("java.lang.Float".equals(typeName) || Float.TYPE == type) {
                    Float oldValue = Float.valueOf(field.getFloat(source));
                    Float newValue = Float.valueOf(field.getFloat(target));
                    return diffUtils.get(path, nameCn, oldValue, newValue);
                }
                if ("java.lang.Double".equals(typeName) || Double.TYPE == type) {
                    String oldValue = field.get(source) == null ? null : String.valueOf(field.get(source));
                    String newValue = field.get(target) == null ? null : String.valueOf(field.get(target));
                    return diffUtils.get(path, nameCn, oldValue, newValue);
                }
                if ("java.util.Date".equals(typeName)) {
                    SimpleDateFormat format = new SimpleDateFormat(StringUtils.isBlank((String)dateFormat) ? "yyyy-MM-dd" : dateFormat);
                    Date newTime = (Date)field.get(target);
                    Date oldTime = (Date)field.get(source);
                    String newTempTimeStr = "";
                    String oldTimeTimeStr = "";
                    if (newTime != null) {
                        newTempTimeStr = format.format(newTime);
                    }
                    if (oldTime != null) {
                        oldTimeTimeStr = format.format(oldTime);
                    }
                    if (oldTime == newTime && oldTime == null) {
                        return null;
                    }
                    if (oldTime == null || newTime == null) {
                        return DiffUtils.getDiffWapper(path, nameCn, oldTime == null ? null : oldTimeTimeStr, newTime == null ? null : newTempTimeStr);
                    }
                    if (!StringUtils.equals((String)newTempTimeStr, (String)oldTimeTimeStr)) {
                        return DiffUtils.getDiffWapper(path, nameCn, oldTimeTimeStr, newTempTimeStr);
                    }
                }
            }
        }
        return null;
    }

    private static String getObjectString(Object source) throws Exception {
        if (source == null) {
            return "";
        }
        ArrayList<String> logList = new ArrayList<String>();
        Field[] fields = source.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String logStr = "";
            Field field = fields[i];
            String typeName = field.getType().getName();
            field.setAccessible(true);
            DiffLog logVo = field.getAnnotation(DiffLog.class);
            String nameCn = field.getName();
            String dateFormat = "";
            if (logVo != null) {
                nameCn = logVo.name();
                dateFormat = logVo.dateFormat();
            }
            if ("java.lang.String".equals(typeName)) {
                String oldStr = (String)field.get(source);
                logStr = "[" + nameCn + "]=" + oldStr + " ";
                logList.add(logStr);
                continue;
            }
            if ("java.sql.Timestamp".equals(typeName) || "java.util.Date".equals(typeName)) {
                SimpleDateFormat format = new SimpleDateFormat(StringUtils.isBlank((String)dateFormat) ? "yyyy-MM-dd HH:mm:ss" : dateFormat);
                Timestamp oldTime = (Timestamp)field.get(source);
                if (oldTime == null) continue;
                logStr = "[" + nameCn + "]=" + format.format(oldTime) + " ";
                logList.add(logStr);
                continue;
            }
            Object oldValue = field.get(source);
            logStr = "[" + nameCn + "]=" + oldValue.toString() + " ";
            logList.add(logStr);
        }
        return StringUtils.join(logList.iterator(), (String)",");
    }
}

