/*
 * Decompiled with CFR 0.152.
 */
package com.github.dreamhead.moco.parser.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.github.dreamhead.moco.Moco;
import com.github.dreamhead.moco.ResponseHandler;
import com.github.dreamhead.moco.handler.failover.Failover;
import com.github.dreamhead.moco.handler.proxy.ProxyConfig;
import com.github.dreamhead.moco.parser.deserializer.ProxyContainerDeserializer;
import com.github.dreamhead.moco.parser.model.FailoverContainer;
import com.github.dreamhead.moco.parser.model.TextContainer;
import com.github.dreamhead.moco.resource.ContentResource;
import com.google.common.base.MoreObjects;

@JsonDeserialize(using=ProxyContainerDeserializer.class)
public class ProxyContainer {
    private TextContainer url;
    private String from;
    private String to;
    private FailoverContainer failover;
    private FailoverContainer playback;

    public final boolean hasUrl() {
        return this.url != null;
    }

    public final String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("url", (Object)this.url).add("from", (Object)this.from).add("to", (Object)this.to).add("failover", (Object)this.failover).add("playback", (Object)this.playback).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public final Failover getFailover() {
        if (this.failover != null) {
            return this.failover.asFailover();
        }
        if (this.playback != null) {
            return this.playback.asPlayback();
        }
        return Failover.DEFAULT_FAILOVER;
    }

    public final ProxyConfig getProxyConfig() {
        return Moco.from((String)this.from).to(this.to);
    }

    private boolean hasProxyConfig() {
        return this.from != null && this.to != null;
    }

    public final ResponseHandler asResponseHandler() {
        Failover failover = this.getFailover();
        if (this.hasProxyConfig()) {
            return Moco.proxy((ProxyConfig)this.getProxyConfig(), (Failover)failover);
        }
        return Moco.proxy((ContentResource)this.url.asResource(), (Failover)failover);
    }

    public static class Builder {
        private TextContainer url;
        private FailoverContainer failover;
        private FailoverContainer playback;
        private String from;
        private String to;

        public final Builder withUrl(String url) {
            this.url = TextContainer.builder().withText(url).build();
            return this;
        }

        public final Builder withUrl(TextContainer container) {
            this.url = container;
            return this;
        }

        public final Builder withFrom(String from) {
            this.from = from;
            return this;
        }

        public final Builder withTo(String to) {
            this.to = to;
            return this;
        }

        public final Builder withFailover(FailoverContainer failover) {
            this.failover = failover;
            return this;
        }

        public final Builder withPlayback(FailoverContainer playback) {
            this.playback = playback;
            return this;
        }

        public final ProxyContainer build() {
            if (this.url != null && (this.from != null || this.to != null)) {
                throw new IllegalArgumentException("Proxy cannot be set in multiple mode");
            }
            if (this.url == null && (this.from == null || this.to == null)) {
                throw new IllegalArgumentException("Batch proxy needs both 'from' and 'to'");
            }
            ProxyContainer container = new ProxyContainer();
            container.url = this.url;
            container.from = this.from;
            container.to = this.to;
            container.failover = this.failover;
            container.playback = this.playback;
            return container;
        }
    }
}

