/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryStorage;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;

public abstract class AbstractWorkbookBuilder
implements IWorkbookBuilder {
    public IWorkbook loadFromPath(String path) throws IOException, CoreException {
        return this.loadFromPath(path, null, null);
    }

    public IWorkbook loadFromPath(String path, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromPath(path, null, encryptionHandler);
    }

    public IWorkbook loadFromPath(String path, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (path == null) {
            throw new IllegalArgumentException("Path is null");
        }
        return this.doLoadFromPath(path, storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromPath(String path, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromFile(new File(path), storage, encryptionHandler);
    }

    public IWorkbook loadFromFile(File file) throws IOException, CoreException {
        return this.loadFromFile(file, null);
    }

    public IWorkbook loadFromFile(File file, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromFile(file, null, encryptionHandler);
    }

    public IWorkbook loadFromFile(File file, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (file == null) {
            throw new IllegalArgumentException("File is null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException("File not exists: " + file);
        }
        if (file.isDirectory()) {
            return this.doLoadFromDirectory(file, storage, encryptionHandler);
        }
        if (!file.canRead()) {
            throw new IOException("File can't be read: " + file);
        }
        return this.doLoadFromFile(file, storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromDirectory(File dir, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromInputSource(new DirectoryInputSource(dir), storage, encryptionHandler);
    }

    protected IWorkbook doLoadFromFile(File file, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException, FileNotFoundException {
        return this.loadFromStream((InputStream)new FileInputStream(file), storage, encryptionHandler);
    }

    public IWorkbook loadFromStream(InputStream in, String tempLocation) throws IOException, CoreException {
        return this.loadFromStream(in, tempLocation, null);
    }

    public IWorkbook loadFromStream(InputStream in, String tempLocation, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new FileNotFoundException("Temp location not found: " + tempLocation);
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Temp location is not directory: " + tempLocation);
        }
        return this.loadFromStream(in, new DirectoryStorage(dir), encryptionHandler);
    }

    public IWorkbook loadFromStream(InputStream in, IStorage storage) throws IOException, CoreException {
        return this.loadFromStream(in, storage, null);
    }

    public IWorkbook loadFromStream(InputStream in, IStorage storage, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        if (in == null) {
            throw new IllegalArgumentException("Input stream is null");
        }
        if (storage == null) {
            throw new IllegalArgumentException("Storage is null");
        }
        return this.doLoadFromSteam(in, storage, encryptionHandler);
    }

    protected abstract IWorkbook doLoadFromSteam(InputStream var1, IStorage var2, IEncryptionHandler var3) throws IOException, CoreException;

    public IWorkbook loadFromTempLocation(String tempLocation) throws IOException, CoreException {
        if (tempLocation == null) {
            throw new IllegalArgumentException("Temp location is null");
        }
        File dir = new File(tempLocation);
        if (!dir.exists()) {
            throw new FileNotFoundException("Temp location not found: " + tempLocation);
        }
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("Temp location is not directory: " + tempLocation);
        }
        DirectoryStorage storage = new DirectoryStorage(dir);
        return this.loadFromInputSource(storage.getInputSource(), storage, null);
    }

    public IWorkbook loadFromStorage(IStorage storage) throws IOException, CoreException {
        return this.loadFromInputSource(null, storage, null);
    }

    public IWorkbook loadFromInputSource(IInputSource source) throws IOException, CoreException {
        return this.loadFromInputSource(source, null, null);
    }

    public IWorkbook loadFromInputSource(IInputSource source, IEncryptionHandler encryptionHandler) throws IOException, CoreException {
        return this.loadFromInputSource(source, null, encryptionHandler);
    }

    public abstract IWorkbook loadFromInputSource(IInputSource var1, IStorage var2, IEncryptionHandler var3) throws IOException, CoreException;
}

