/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.Core;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NumberUtils;
import org.xmind.core.util.DOMUtils;

public class InternalDOMUtils {
    public static void addVersion(Document document) {
        Element element = document.getDocumentElement();
        if (element != null && !element.hasAttribute("version")) {
            DOMUtils.setAttribute(element, "version", Core.getCurrentVersion());
        }
    }

    public static void replaceVersion(Document document) {
        Element element = document.getDocumentElement();
        if (element != null) {
            DOMUtils.setAttribute(element, "version", Core.getCurrentVersion());
        }
    }

    public static String getParentPath(String path) {
        int i = path.endsWith("/") ? path.lastIndexOf(47, path.length() - 2) : path.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        return path.substring(0, i + 1);
    }

    public static String getLastName(String path) {
        String parent = InternalDOMUtils.getParentPath(path);
        if (parent != null) {
            return path.substring(parent.length());
        }
        return path;
    }

    public static boolean isParentPath(String path, String parentPath) {
        return path.startsWith(parentPath);
    }

    public static String trim(String text) {
        return text == null ? null : text.trim();
    }

    public static String trimElementContent(String text, String tagName) {
        int start = text.indexOf("<" + tagName + " ");
        if (start < 0) {
            start = text.indexOf("<" + tagName + ">");
        }
        if (start >= 0) {
            if ((start = text.indexOf(62, start + 1)) > 0) {
                int i = start - 1;
                while (text.charAt(i) != '<') {
                    if (text.charAt(i) == '/') {
                        return null;
                    }
                    --i;
                }
            }
            ++start;
        }
        int end = text.lastIndexOf("</" + tagName + ">");
        if (start > 0 || end >= 0 && end < text.length()) {
            return text.substring(start, end);
        }
        return text;
    }

    public static String makeElementText(String text, NS defaultNS, String tagName, NS ... nss) {
        if (tagName != null && text.indexOf("<" + tagName) < 0) {
            StringBuffer sb = new StringBuffer(tagName.length() + (defaultNS != null ? defaultNS.getURI().length() : 0) + nss.length * 20 + 2);
            sb.append('<');
            sb.append(tagName);
            if (defaultNS != null) {
                sb.append(" xmlns=\"");
                sb.append(defaultNS.getURI());
                sb.append('\"');
            }
            for (NS ns : nss) {
                sb.append(" xmlns:");
                sb.append(ns.getPrefix());
                sb.append('=');
                sb.append('\"');
                sb.append(ns.getURI());
                sb.append('\"');
            }
            sb.append('>');
            sb.append(text);
            sb.append('<');
            sb.append('/');
            sb.append(tagName);
            sb.append('>');
            return sb.toString();
        }
        return text;
    }

    public static String toRangeValue(int startIndex, int endIndex) {
        if (startIndex >= 0 || endIndex >= 0) {
            StringBuilder sb = new StringBuilder();
            sb.append('(');
            if (startIndex >= 0) {
                sb.append(startIndex);
            }
            sb.append(',');
            if (endIndex >= 0) {
                sb.append(endIndex);
            }
            sb.append(')');
            return sb.toString();
        }
        return null;
    }

    public static int getStartIndex(String rangeValue) {
        int sep;
        if (rangeValue != null && rangeValue.startsWith("(") && rangeValue.endsWith(")") && (sep = rangeValue.indexOf(44)) > 0) {
            String startIndexValue = rangeValue.substring(1, sep).trim();
            int index = NumberUtils.safeParseInt(startIndexValue, -1);
            return index < 0 ? -1 : index;
        }
        return -1;
    }

    public static int getEndIndex(String rangeValue) {
        int sep;
        if (rangeValue != null && rangeValue.startsWith("(") && rangeValue.endsWith(")") && (sep = rangeValue.lastIndexOf(44)) > 0) {
            String endIndexValue = rangeValue.substring(sep + 1, rangeValue.length() - 1).trim();
            int index = NumberUtils.safeParseInt(endIndexValue, -1);
            return index < 0 ? -1 : index;
        }
        return -1;
    }
}

