/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class NumberUtils {
    private static DateFormat dateFormat = null;

    public static int safeParseInt(String string, int defaultReturn) {
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultReturn;
    }

    public static float safeParseFloat(String s, float defaultFloat) {
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultFloat;
    }

    public static double safeParseDouble(String s, double defaultValue) {
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static long safeParseLong(String s, long defaultLong) {
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return defaultLong;
    }

    private static DateFormat getDateFormat() {
        if (dateFormat == null) {
            dateFormat = DateFormat.getDateTimeInstance(2, 2);
        }
        return dateFormat;
    }

    public static String formatDate(long time) {
        Date date = new Date(time);
        return NumberUtils.getDateFormat().format(date);
    }

    public static long parseDate(String time) {
        if (time == null) {
            return System.currentTimeMillis();
        }
        try {
            Date date = NumberUtils.getDateFormat().parse(time);
            return date.getTime();
        }
        catch (ParseException e) {
            return System.currentTimeMillis();
        }
    }
}

