/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.Numbering;
import org.xmind.core.internal.dom.TopicImpl;
import org.xmind.core.util.DOMUtils;

public class NumberingImpl
extends Numbering
implements ICoreEventSource {
    private Element topicElement;
    private TopicImpl ownedTopic;

    public NumberingImpl(Element topicElement, TopicImpl ownedTopic) {
        this.topicElement = topicElement;
        this.ownedTopic = ownedTopic;
    }

    public Element getNumberingElement() {
        return DOMUtils.getFirstChildElementByTag(this.topicElement, "numbering");
    }

    public Object getAdapter(Class adapter) {
        if (adapter == Node.class || adapter == Element.class) {
            return this.getNumberingElement();
        }
        return super.getAdapter(adapter);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof NumberingImpl)) {
            return false;
        }
        NumberingImpl that = (NumberingImpl)obj;
        return this.topicElement == that.topicElement;
    }

    public int hashCode() {
        return this.topicElement.hashCode();
    }

    public String toString() {
        return "Numbering of " + this.ownedTopic;
    }

    public String getNumberFormat() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return null;
        }
        return DOMUtils.getAttribute(e, "number-format");
    }

    public String getPrefix() {
        return this.getText("prefix");
    }

    public String getSuffix() {
        return this.getText("suffix");
    }

    public boolean prependsParentNumbers() {
        Element e = this.getNumberingElement();
        if (e == null) {
            return true;
        }
        String value = DOMUtils.getAttribute(e, "prepending-numbers");
        return !"none".equals(value);
    }

    public ITopic getParent() {
        return this.ownedTopic;
    }

    public ISheet getOwnedSheet() {
        return this.ownedTopic.getOwnedSheet();
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownedTopic.getOwnedWorkbook();
    }

    public boolean isOrphan() {
        return this.ownedTopic.isOrphan();
    }

    private void setAttribute(String key, String value) {
        if (value == null) {
            Element e = this.getNumberingElement();
            if (e != null) {
                e.removeAttribute(key);
                if (!e.hasAttributes() && !e.hasChildNodes()) {
                    this.topicElement.removeChild(e);
                }
            }
        } else {
            Element e = DOMUtils.ensureChildElement(this.topicElement, "numbering");
            e.setAttribute(key, value);
        }
    }

    private String getText(String key) {
        Element e = this.getNumberingElement();
        if (e != null) {
            return DOMUtils.getTextContentByTag(e, key);
        }
        return null;
    }

    private void setText(String key, String value) {
        if (value == null) {
            Element t;
            Element e = this.getNumberingElement();
            if (e != null && (t = DOMUtils.getFirstChildElementByTag(e, key)) != null) {
                e.removeChild(t);
                if (!e.hasAttributes() && !e.hasChildNodes()) {
                    this.topicElement.removeChild(e);
                }
            }
        } else {
            Element e = DOMUtils.ensureChildElement(this.topicElement, "numbering");
            Element t = DOMUtils.ensureChildElement(e, key);
            t.setTextContent(value);
        }
    }

    public void setFormat(String format) {
        String oldValue = this.getNumberFormat();
        this.setAttribute("number-format", format);
        String newValue = this.getNumberFormat();
        this.fireValueChange("numberingFormat", oldValue, newValue);
        this.ownedTopic.updateModifiedTime();
    }

    public void setPrefix(String prefix) {
        String oldValue = this.getPrefix();
        this.setText("prefix", prefix);
        String newValue = this.getPrefix();
        this.fireValueChange("numberingPrefix", oldValue, newValue);
        this.ownedTopic.updateModifiedTime();
    }

    public void setPrependsParentNumbers(boolean prepend) {
        Boolean oldValue = this.prependsParentNumbers();
        this.setAttribute("prepending-numbers", prepend ? null : "none");
        Boolean newValue = this.prependsParentNumbers();
        this.fireValueChange("parentNumberingPrepending", oldValue, newValue);
        this.ownedTopic.updateModifiedTime();
    }

    public void setSuffix(String suffix) {
        String oldValue = this.getSuffix();
        this.setText("suffix", suffix);
        String newValue = this.getSuffix();
        this.fireValueChange("numberingSuffix", oldValue, newValue);
        this.ownedTopic.updateModifiedTime();
    }

    private void fireValueChange(String eventType, Object oldValue, Object newValue) {
        this.getCoreEventSupport().dispatchValueChange(this, eventType, oldValue, newValue);
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownedTopic.getCoreEventSupport();
    }
}

