/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xmind.core.CoreException;
import org.xmind.core.internal.StyleSheetBuilder;
import org.xmind.core.internal.dom.StyleSheetImpl;
import org.xmind.core.io.IInputSource;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IXMLLoader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class StyleSheetBuilderImpl
extends StyleSheetBuilder
implements ErrorHandler {
    private DocumentBuilder documentCreator = null;
    private DocumentBuilder documentLoader = null;

    private DocumentBuilder getDocumentCreator() {
        if (this.documentCreator == null) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                this.documentCreator = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new IllegalStateException(e);
            }
        }
        return this.documentCreator;
    }

    private DocumentBuilder getDocumentLoader() throws CoreException {
        if (this.documentLoader == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setAttribute("http://apache.org/xml/features/continue-after-fatal-error", Boolean.TRUE);
            try {
                this.documentLoader = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                throw new CoreException(12, (Throwable)e);
            }
            this.documentLoader.setErrorHandler(this);
        }
        return this.documentLoader;
    }

    private Document createDocument() {
        return this.getDocumentCreator().newDocument();
    }

    public IStyleSheet createStyleSheet() {
        Document impl = this.createDocument();
        DOMUtils.createElement(impl, "xmap-styles");
        StyleSheetImpl sheet = new StyleSheetImpl(impl);
        return sheet;
    }

    public IStyleSheet loadFromStream(InputStream stream) throws IOException, CoreException {
        DocumentBuilder loader = this.getDocumentLoader();
        Document doc = this.parse(loader, stream);
        return this.createStyleSheet(doc);
    }

    public IStyleSheet loadFromInputSource(IInputSource source, IXMLLoader xmlLoader) throws IOException, CoreException {
        Document doc = xmlLoader.loadXMLFile(source, "styles.xml");
        return this.createStyleSheet(doc);
    }

    private IStyleSheet createStyleSheet(Document doc) {
        this.fixbug(doc);
        StyleSheetImpl sheet = new StyleSheetImpl(doc);
        this.init(sheet);
        return sheet;
    }

    private void init(StyleSheetImpl sheet) {
        for (IStyle style : sheet.getAllStyles()) {
            this.init(style);
        }
    }

    private void init(IStyle style) {
    }

    private Document parse(DocumentBuilder loader, InputStream stream) throws IOException, CoreException {
        try {
            return loader.parse(stream);
        }
        catch (SAXException e) {
            throw new CoreException(13);
        }
        catch (IOException e) {
            throw e;
        }
    }

    public void loadProperties(InputStream stream, IStyleSheet styleSheet) throws IOException, CoreException {
        Properties p = new Properties();
        p.load(stream);
        ((StyleSheetImpl)styleSheet).setProperties(p);
    }

    public void error(SAXParseException exception) throws SAXException {
    }

    public void fatalError(SAXParseException exception) throws SAXException {
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    private void fixbug(Document doc) {
        Element element = doc.getDocumentElement();
        if (element != null) {
            this.fixbug(element);
        }
    }

    private void fixbug(Element element) {
        String value = element.getAttribute("shape-class");
        if ("org.xmind.topicShape.rectangle".equals(value)) {
            element.setAttribute("shape-class", "org.xmind.topicShape.rect");
        }
        Iterator<Element> it = DOMUtils.childElementIter(element);
        while (it.hasNext()) {
            this.fixbug(it.next());
        }
    }
}

