/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IManifest;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.ElementRegistry;
import org.xmind.core.internal.StyleSheet;
import org.xmind.core.internal.dom.INodeAdaptableFactory;
import org.xmind.core.internal.dom.INodeAdaptableProvider;
import org.xmind.core.internal.dom.InternalDOMUtils;
import org.xmind.core.internal.dom.NS;
import org.xmind.core.internal.dom.NodeAdaptableProvider;
import org.xmind.core.internal.dom.StyleImpl;
import org.xmind.core.internal.dom.WorkbookUtilsImpl;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.DOMUtils;
import org.xmind.core.util.IPropertiesProvider;
import org.xmind.core.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetImpl
extends StyleSheet
implements INodeAdaptableFactory,
ICoreEventSource,
IPropertiesProvider {
    private Document implementation;
    private ElementRegistry elementRegistry = null;
    private NodeAdaptableProvider nodeAdaptableProvider = null;
    private CoreEventSupport coreEventSupport = null;
    private Properties properties = null;
    private IManifest manifest = null;

    public StyleSheetImpl(Document implementation) {
        this.implementation = implementation;
        this.init();
    }

    private void init() {
        Element s = DOMUtils.ensureChildElement(this.implementation, "xmap-styles");
        NS.setNS(NS.Style, s, NS.SVG, NS.Fo);
        InternalDOMUtils.addVersion(this.implementation);
    }

    public Document getImplementation() {
        return this.implementation;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == ElementRegistry.class) {
            return this.getElementRegistry();
        }
        if (adapter == ICoreEventSupport.class) {
            return this.getCoreEventSupport();
        }
        if (adapter == IPropertiesProvider.class) {
            return this;
        }
        if (adapter == Properties.class) {
            return this.getProperties();
        }
        if (adapter == INodeAdaptableFactory.class) {
            return this;
        }
        if (adapter == INodeAdaptableProvider.class) {
            return this.getNodeAdaptableProvider();
        }
        if (adapter == Document.class || adapter == Node.class) {
            return this.implementation;
        }
        return super.getAdapter(adapter);
    }

    protected Element getSheetElement() {
        return this.implementation.getDocumentElement();
    }

    @Override
    public boolean isEmpty() {
        return !this.getSheetElement().hasChildNodes();
    }

    @Override
    protected IStyle getLocalStyle(String styleId) {
        Object element = this.getElementById(styleId);
        return element instanceof IStyle ? (IStyle)element : null;
    }

    @Override
    public IStyle createStyle(String type) {
        Element s = this.implementation.createElement("style");
        s.setAttribute("type", type);
        StyleImpl style = new StyleImpl(s, this);
        this.getElementRegistry().register(style);
        return style;
    }

    @Override
    public Set<IStyle> getStyles(String groupName) {
        Element ss;
        String groupTag = this.getGroupTag(groupName);
        if (groupTag != null && (ss = DOMUtils.getFirstChildElementByTag(this.getSheetElement(), groupTag)) != null) {
            return DOMUtils.getChildSet(ss, "style", this.getNodeAdaptableProvider());
        }
        return NO_STYLES;
    }

    @Override
    public void addStyle(IStyle style, String groupName) {
        String groupTag = this.getGroupTag(groupName);
        if (groupTag == null) {
            return;
        }
        Element s = ((StyleImpl)style).getImplementation();
        Element as = DOMUtils.ensureChildElement(this.getSheetElement(), groupTag);
        Node n = as.appendChild(s);
        if (n != null) {
            this.fireTargetChange("styleAdd", style);
        }
    }

    @Override
    public String findOwnedGroup(IStyle style) {
        StyleImpl s = (StyleImpl)style;
        Node p = s.getImplementation().getParentNode();
        if (p instanceof Element) {
            String groupTag = ((Element)p).getTagName();
            return this.getGroupName(groupTag);
        }
        return null;
    }

    private String getGroupTag(String groupName) {
        if ("normal-styles".equals(groupName)) {
            return "styles";
        }
        if ("master-styles".equals(groupName)) {
            return "master-styles";
        }
        if ("automatic-styles".equals(groupName)) {
            return "automatic-styles";
        }
        return null;
    }

    private String getGroupName(String groupTag) {
        if ("styles".equals(groupTag)) {
            return "normal-styles";
        }
        if ("master-styles".equals(groupTag)) {
            return "master-styles";
        }
        if ("automatic-styles".equals(groupTag)) {
            return "automatic-styles";
        }
        return null;
    }

    @Override
    public void removeStyle(IStyle style) {
        Element s = ((StyleImpl)style).getImplementation();
        Node p = s.getParentNode();
        if (p instanceof Element) {
            Node n;
            Element ss = (Element)p;
            Element sheet = this.getSheetElement();
            if (ss.getParentNode() == sheet && (n = ss.removeChild(s)) != null) {
                if (!ss.hasChildNodes()) {
                    sheet.removeChild(ss);
                }
                this.fireTargetChange("styleRemove", style);
            }
        }
    }

    protected Object getElementById(String id) {
        Element domElement;
        Object element = this.getElementRegistry().getElement(id);
        if (element == null && (domElement = this.implementation.getElementById(id)) != null) {
            element = this.getNodeAdaptable(domElement);
        }
        return element;
    }

    public ElementRegistry getElementRegistry() {
        if (this.elementRegistry == null) {
            this.elementRegistry = new ElementRegistry();
        }
        return this.elementRegistry;
    }

    protected NodeAdaptableProvider getNodeAdaptableProvider() {
        if (this.nodeAdaptableProvider == null) {
            this.nodeAdaptableProvider = new NodeAdaptableProvider(this.getElementRegistry(), this, this.implementation);
        }
        return this.nodeAdaptableProvider;
    }

    protected IAdaptable getNodeAdaptable(Node node) {
        return this.getNodeAdaptableProvider().getAdaptable(node);
    }

    @Override
    public IAdaptable createAdaptable(Node node) {
        Element e;
        String tagName;
        if (node instanceof Element && "style".equals(tagName = (e = (Element)node).getTagName())) {
            return new StyleImpl(e, this);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof StyleSheetImpl)) {
            return false;
        }
        StyleSheetImpl that = (StyleSheetImpl)obj;
        return this.implementation == that.implementation;
    }

    public int hashCode() {
        return this.implementation.hashCode();
    }

    public String toString() {
        return DOMUtils.toString(this.implementation);
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public IManifest getManifest() {
        return this.manifest;
    }

    public void setManifest(IManifest manifest) {
        this.manifest = manifest;
    }

    @Override
    public void save(OutputStream out) throws IOException, CoreException {
        DOMUtils.save(this.implementation, out, false);
    }

    @Override
    public IStyle importStyle(IStyle style) {
        if (style == null) {
            return null;
        }
        if (style instanceof StyleImpl) {
            StyleImpl s = (StyleImpl)style;
            return WorkbookUtilsImpl.importStyle(this, s, (StyleSheetImpl)style.getOwnedStyleSheet());
        }
        return this.importStyleFromOtherImpl(style);
    }

    private IStyle importStyleFromOtherImpl(IStyle style) {
        String group;
        IStyle target = this.createStyle(style.getType());
        Iterator<Property> sourcePropIt = style.properties();
        while (sourcePropIt.hasNext()) {
            Property sourceProperty = sourcePropIt.next();
            target.setProperty(sourceProperty.key, sourceProperty.value);
        }
        Iterator<Property> sourceDSIt = style.defaultStyles();
        while (sourceDSIt.hasNext()) {
            Property sourceDS = sourceDSIt.next();
            target.setDefaultStyleId(sourceDS.key, sourceDS.value);
        }
        IStyleSheet sourceSheet = style.getOwnedStyleSheet();
        if (sourceSheet != null && (group = sourceSheet.findOwnedGroup(style)) != null) {
            this.addStyle(target, group);
        }
        return target;
    }

    @Override
    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerCoreEventListener(this, type, listener);
    }

    @Override
    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport != null) {
            return this.coreEventSupport;
        }
        this.coreEventSupport = new CoreEventSupport();
        return this.coreEventSupport;
    }

    private void fireTargetChange(String type, Object target) {
        this.getCoreEventSupport().dispatchTargetChange(this, type, target);
    }
}

