/*
 * Decompiled with CFR 0.152.
 */
package xmindjbehave.xmind;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IEncryptionHandler;
import org.xmind.core.INotes;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbookBuilder;
import org.xmind.core.io.ByteArrayStorage;
import org.xmind.core.marker.IMarkerRef;
import xmindjbehave.xmind.AbstractToXmindMojo;

@Mojo(name="generateXMindFromTestResults", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class GenerateXMindFromTestResults
extends AbstractToXmindMojo {
    @Deprecated
    public static void main(String[] args) {
        GenerateXMindFromTestResults gen = new GenerateXMindFromTestResults();
        try {
            gen.outputResultsDir = new File("C:\\pegas\\target\\jbehave");
            gen.xmindpath = "C:\\pegas\\example.xmind";
            gen.xmindprefix = "C:\\pegas\\example";
            gen.outputDirectory = new File("C:\\pegas\\src\\test\\resources\\");
            gen.useSingleOutput = true;
            gen.execute();
        }
        catch (MojoExecutionException e) {
            e.printStackTrace();
        }
        catch (MojoFailureException e) {
            e.printStackTrace();
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        String workbookString = this.xmindpath;
        IWorkbookBuilder builder = Core.getWorkbookBuilder();
        ByteArrayStorage ist = new ByteArrayStorage();
        IEncryptionHandler iench = new IEncryptionHandler(){

            @Override
            public String retrievePassword() throws CoreException {
                return "privet";
            }
        };
        try {
            this.wb = builder.loadFromPath(workbookString, ist, iench);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (ISheet isheet : this.wb.getSheets()) {
            System.out.println(isheet.getId());
            ITopic root = isheet.getRootTopic();
            try {
                this.iterateOverTopicMarkAllGreen(root, "", this.outputResultsDir.getPath());
                this.iterateOverTopic(root, "", this.outputResultsDir.getPath());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            if (this.useSingleOutput) {
                this.wb.save(this.xmindprefix + "-LAST.xmind");
            } else {
                this.wb.save(this.xmindprefix + new Date().toString().replace(" ", "").replace(":", "") + ".xmind");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateOverTopic(ITopic itop, String offset, String folderBase) throws IOException {
        System.out.println(offset + itop.getTitleText());
        boolean folderCreated = new File(folderBase).mkdirs();
        String parentbase = folderBase;
        for (ITopic child : itop.getAllChildren()) {
            this.iterateOverTopic(child, offset + " ", folderBase + "\\" + itop.getTitleText());
        }
        if (itop.getNotes() != null) {
            INotes nt = itop.getNotes();
            IPlainNotesContent plainContent = (IPlainNotesContent)nt.getContent("plain");
            BufferedReader br = null;
            String statsfilepath = this.outputResultsDir.getPath() + "\\" + folderBase.replace(this.outputResultsDir.getPath() + "\\", "").replace("\\", ".") + "." + itop.getTitleText() + ".stats";
            System.out.println("Setting marker of " + statsfilepath + "");
            try {
                String sCurrentLine;
                br = new BufferedReader(new FileReader(statsfilepath));
                while ((sCurrentLine = br.readLine()) != null) {
                    System.out.println(sCurrentLine);
                    if (!sCurrentLine.contains("stepsFailed=")) continue;
                    if (!sCurrentLine.contains("stepsFailed=0")) {
                        this.setMarkerToTopicAndParent(itop, "smiley-angry", "smiley-smile");
                        System.out.println("Setting marker of " + statsfilepath + " to smiley-angry (RED)");
                        continue;
                    }
                    itop.removeMarker("smiley-angry");
                    itop.addMarker("smiley-smile");
                    System.out.println("Setting marker of " + statsfilepath + " to smiley-smile (GREEN)");
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (br != null) {
                        br.close();
                    }
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateOverTopicMarkAllGreen(ITopic itop, String offset, String folderBase) throws IOException {
        System.out.println(offset + itop.getTitleText());
        boolean folderCreated = new File(folderBase).mkdirs();
        String parentbase = folderBase;
        for (ITopic child : itop.getAllChildren()) {
            this.iterateOverTopicMarkAllGreen(child, offset + " ", folderBase + "\\" + itop.getTitleText());
        }
        if (itop.getNotes() != null) {
            INotes nt = itop.getNotes();
            if (!nt.toString().equals("null")) {
                IPlainNotesContent plainContent = (IPlainNotesContent)nt.getContent("plain");
                BufferedReader br = null;
                BufferedReader br2 = null;
                String statsfilepath = this.outputResultsDir.getPath() + "\\" + folderBase.replace(this.outputResultsDir.getPath() + "\\", "").replace("\\", ".") + "." + itop.getTitleText() + ".stats";
                String specfilepath = this.outputDirectory.getPath() + "\\" + folderBase.replace(this.outputResultsDir.getPath() + "\\", "") + "\\" + itop.getTitleText() + ".story";
                System.out.println("Setting marker of " + statsfilepath + "");
                try {
                    String sCurrentLine;
                    String toBeWrittenToITop = "";
                    try {
                        br = new BufferedReader(new FileReader(statsfilepath));
                        while ((sCurrentLine = br.readLine()) != null) {
                            System.out.println(sCurrentLine);
                            if (!sCurrentLine.contains("stepsFailed=")) continue;
                            this.setMarkerToTopicAndParent(itop, "smiley-smile", "smiley-angry");
                        }
                    }
                    catch (FileNotFoundException f) {
                        toBeWrittenToITop = "";
                    }
                    try {
                        br2 = new BufferedReader(new FileReader(specfilepath));
                        while ((sCurrentLine = br2.readLine()) != null) {
                            toBeWrittenToITop = toBeWrittenToITop + sCurrentLine + "\n";
                        }
                    }
                    catch (FileNotFoundException f) {
                        System.out.println("File " + specfilepath + " is not fount");
                        toBeWrittenToITop = "";
                    }
                    ITopic newitop = this.wb.createTopic();
                    if (!toBeWrittenToITop.equals("")) {
                        IPlainNotesContent plainContent2 = (IPlainNotesContent)this.wb.createNotesContent("plain");
                        plainContent2.setTextContent(toBeWrittenToITop);
                        INotes notes = newitop.getNotes();
                        notes.setContent("plain", plainContent2);
                    }
                    for (IMarkerRef mr : itop.getMarkerRefs()) {
                        newitop.addMarker(mr.getMarkerId());
                    }
                    for (ITopic tp : itop.getAllChildren()) {
                        newitop.add(tp);
                    }
                    newitop.setTitleText(itop.getTitleText());
                    newitop.setFolded(itop.isFolded());
                    itop.getParent().add(newitop);
                    itop.getParent().remove(itop);
                }
                catch (FileNotFoundException e) {
                    itop.setFolded(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                itop.setFolded(true);
            }
        }
    }

    public void setMarkerToTopicAndParent(ITopic itopic, String markersToAdd, String markersToRemove) {
        ITopic parent = itopic.getParent();
        itopic.removeMarker(markersToRemove);
        itopic.addMarker(markersToAdd);
        itopic.setFolded(false);
        boolean flag = true;
        System.out.println("checking topic " + itopic.getTitleText());
        if (parent != null) {
            this.setMarkerToTopicAndParent(parent, markersToAdd, markersToRemove);
        }
    }
}

