/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.dependency;

import com.github.ferstl.depgraph.dependency.DependencyNode;
import com.github.ferstl.depgraph.dependency.NodeResolution;
import com.github.ferstl.depgraph.graph.GraphBuilder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.eclipse.aether.graph.DependencyVisitor;

class GraphBuildingVisitor
implements DependencyVisitor {
    private final GraphBuilder<DependencyNode> graphBuilder;
    private final Deque<DependencyNode> nodeStack;
    private final ArtifactFilter globalFilter;
    private final ArtifactFilter transitiveFilter;
    private final ArtifactFilter targetFilter;
    private final Set<NodeResolution> includedResolutions;
    private int cutOffDepth = 0;

    GraphBuildingVisitor(GraphBuilder<DependencyNode> graphBuilder, ArtifactFilter globalFilter, ArtifactFilter transitiveFilter, ArtifactFilter targetFilter, Set<NodeResolution> includedResolutions) {
        this.graphBuilder = graphBuilder;
        this.nodeStack = new ArrayDeque<DependencyNode>();
        this.globalFilter = globalFilter;
        this.transitiveFilter = transitiveFilter;
        this.targetFilter = targetFilter;
        this.includedResolutions = includedResolutions;
    }

    public boolean visitEnter(org.eclipse.aether.graph.DependencyNode node) {
        DependencyNode node1 = new DependencyNode(node);
        if (this.isExcluded(node1)) {
            return true;
        }
        this.nodeStack.push(node1);
        if (this.targetFilter.include(node1.getArtifact())) {
            this.cutOffDepth = this.nodeStack.size();
        }
        return true;
    }

    public boolean visitLeave(org.eclipse.aether.graph.DependencyNode node) {
        DependencyNode dependencyNode = new DependencyNode(node);
        if (this.isExcluded(dependencyNode)) {
            return true;
        }
        this.nodeStack.pop();
        DependencyNode currentParent = this.nodeStack.peek();
        if (this.nodeStack.size() < this.cutOffDepth) {
            this.cutOffDepth = this.nodeStack.size();
            if (currentParent != null) {
                this.mergeWithExisting(dependencyNode);
                if ("test".equals(dependencyNode.getArtifact().getScope())) {
                    this.graphBuilder.addPermanentEdge(currentParent, dependencyNode);
                } else {
                    this.graphBuilder.addEdge(currentParent, dependencyNode);
                }
            }
        }
        return true;
    }

    private boolean isExcluded(DependencyNode node) {
        Artifact artifact = node.getArtifact();
        return !this.globalFilter.include(artifact) || !this.transitiveFilter.include(artifact) || !this.includedResolutions.contains((Object)node.getResolution());
    }

    private void mergeWithExisting(DependencyNode node) {
        DependencyNode effectiveNode = this.graphBuilder.getEffectiveNode(node);
        node.merge(effectiveNode);
    }
}

