/*
 * Decompiled with CFR 0.152.
 */
package com.github.ferstl.depgraph.graph.dot;

import com.google.common.html.HtmlEscapers;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;

public class DotLabelBuilder {
    private static final String NEWLINE = "<br/>";
    private final StringBuilder labelBuilder = new StringBuilder();
    private boolean smartNewLine;
    private boolean empty = true;

    public DotLabelBuilder text(String text) {
        this.addText(text);
        return this;
    }

    public DotLabelBuilder italic(String text) {
        this.addText(text, "i", new String[0]);
        return this;
    }

    public DotLabelBuilder bold(String text) {
        this.addText(text, "b", new String[0]);
        return this;
    }

    public DotLabelBuilder underline(String text) {
        this.addText(text, "u", new String[0]);
        return this;
    }

    public DotLabelBuilder newLine() {
        this.labelBuilder.append(NEWLINE);
        return this;
    }

    public DotLabelBuilder smartNewLine() {
        this.smartNewLine = true;
        return this;
    }

    public FontBuilder font() {
        return new FontBuilder();
    }

    public String build() {
        if (this.labelBuilder.length() == 0) {
            return "";
        }
        return "<" + this.labelBuilder + ">";
    }

    private void addText(String text, String tagName, String ... tagAttributes) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        this.labelBuilder.append("<").append(tagName);
        for (String attribute : tagAttributes) {
            this.labelBuilder.append(" ").append(attribute);
        }
        this.labelBuilder.append(">");
        this.addText(text);
        this.labelBuilder.append("</").append(tagName).append(">");
        this.empty = false;
    }

    private void addText(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return;
        }
        if (this.smartNewLine && !this.empty) {
            this.newLine();
            this.smartNewLine = false;
        }
        this.labelBuilder.append(HtmlEscapers.htmlEscaper().escape(text));
        this.empty = false;
    }

    public class FontBuilder {
        private final Map<String, String> attributes = new TreeMap<String, String>();

        public FontBuilder color(String color) {
            this.addAttribute("color", color);
            return this;
        }

        public FontBuilder size(int size) {
            if (size > 0) {
                this.addAttribute("point-size", size);
            } else if (size < 0) {
                throw new IllegalArgumentException("Font size must not be negative");
            }
            return this;
        }

        public FontBuilder size(Integer size) {
            return this.size(size != null ? size : 0);
        }

        public FontBuilder name(String font) {
            this.addAttribute("face", font);
            return this;
        }

        public DotLabelBuilder text(String text) {
            if (this.attributes.size() > 0) {
                DotLabelBuilder.this.addText(text, "font", this.attributes.values().toArray(new String[0]));
            } else {
                DotLabelBuilder.this.text(text);
            }
            return DotLabelBuilder.this;
        }

        private void addAttribute(String name, Object value) {
            if (value != null) {
                this.attributes.put(name, name + "=\"" + value + "\"");
            }
        }
    }
}

