/*
 * Decompiled with CFR 0.152.
 */
package com.github.fppt.jedismock.operations.keys;

import com.github.fppt.jedismock.datastructures.Slice;
import com.github.fppt.jedismock.operations.AbstractRedisOperation;
import com.github.fppt.jedismock.operations.RedisCommand;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationExtraParam;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationParamsException;
import com.github.fppt.jedismock.operations.keys.paramsparser.ExpirationTimeParam;
import com.github.fppt.jedismock.server.Response;
import com.github.fppt.jedismock.storage.RedisBase;
import java.util.List;

@RedisCommand(value="pexpire")
class PExpire
extends AbstractRedisOperation {
    PExpire(RedisBase base, List<Slice> params) {
        super(base, params);
    }

    @Override
    protected int minArgs() {
        return 2;
    }

    protected boolean useMillis() {
        return true;
    }

    @Override
    protected Slice response() {
        try {
            Slice key = this.params().get(0);
            ExpirationTimeParam expirationTime = new ExpirationTimeParam(this.self().value(), this.params().get(1), this.useMillis(), this.base().getClock().millis());
            ExpirationExtraParam extraParam = new ExpirationExtraParam(this.params(), false);
            long newTTL = expirationTime.getMillis();
            if (this.base().exists(key) && extraParam.checkTiming(this.base().getTTL(key), newTTL)) {
                return Response.integer(this.base().setTTL(key, newTTL));
            }
            return Response.integer(0L);
        }
        catch (ExpirationParamsException e) {
            return Response.error(e.getMessage());
        }
    }
}

