/*
 * Copyright (c)  2019. houbinbin Inc.
 * heaven All rights reserved.
 */

package com.github.houbb.heaven.constant;

/**
 * maven 项目常量
 *
 * @author bbhou
 * @version 0.0.1
 */
public final class MavenConst {

    private MavenConst(){}

    /**
     * 目标class文件路径后缀
     */
    public static final String TARGET_CLASSES_PATH_SUFFIX = "target/classes/";

    /**
     * main-java文件默认存放路径
     */
    public static final String SRC_MAIN_JAVA_PATH = "src/main/java/";

    /**
     * main-资源文件存放路径
     */
    public static final String SRC_MAIN_RESOURCES_PATH = "src/main/resources/";

    /**
     * java测试文件默认存放路径
     */
    public static final String SRC_TEST_JAVA_PATH = "src/test/java/";

    /**
     * 测试资源文件存放路径
     */
    public static final String SRC_TEST_RESOURCES_PATH = "src/test/resources/";

}
