/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.idoc.common.util;

import com.github.houbb.idoc.common.handler.IHandler;
import com.github.houbb.idoc.common.util.ArrayUtil;
import com.github.houbb.idoc.common.util.ObjectUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class CollectionUtil {
    public static boolean isEmpty(Collection<?> collection) {
        return null == collection || collection.size() == 0;
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtil.isEmpty(collection);
    }

    public static <T, R> List<R> buildList(Collection<T> targets, IHandler<T, R> handler) {
        if (CollectionUtil.isEmpty(targets)) {
            return Collections.emptyList();
        }
        ArrayList<R> rList = new ArrayList<R>(targets.size());
        for (T t : targets) {
            R r = handler.handle(t);
            if (ObjectUtil.isNull(t)) continue;
            rList.add(r);
        }
        return rList;
    }

    public static <T> void addArray(Collection<T> collection, T[] array) {
        if (ArrayUtil.isEmpty(array)) {
            return;
        }
        collection.addAll(Arrays.asList(array));
    }
}

