/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.log.integration.adaptors.jdk14;

import com.github.houbb.log.integration.core.Log;
import com.github.houbb.log.integration.util.ExceptionUtil;
import com.github.houbb.log.integration.util.LogUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Jdk14LoggingImpl
implements Log {
    private Logger log;

    public Jdk14LoggingImpl(String clazz) {
        this.log = Logger.getLogger(clazz);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.log.isLoggable(Level.FINE);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.log.isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatalEnabled() {
        return false;
    }

    @Override
    public boolean isInfoEnabled() {
        return this.log.isLoggable(Level.INFO);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.log.isLoggable(Level.FINER);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.log.isLoggable(Level.WARNING);
    }

    @Override
    public void fatal(String s, Throwable e) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e) {
        this.log.log(Level.SEVERE, s, e);
    }

    @Override
    public void error(String s) {
        this.log.log(Level.SEVERE, s);
    }

    @Override
    public void debug(String s) {
        this.log.log(Level.FINE, s);
    }

    @Override
    public void trace(String s) {
        this.log.log(Level.FINER, s);
    }

    @Override
    public void warn(String s) {
        this.log.log(Level.WARNING, s);
    }

    @Override
    public void info(String s) {
        this.log.log(Level.INFO, s);
    }

    @Override
    public void fatal(String s, Throwable e, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void fatal(String s, Object ... params) {
        ExceptionUtil.throwUnsupportedOperationException();
    }

    @Override
    public void error(String s, Throwable e, Object ... params) {
        this.log.log(Level.SEVERE, LogUtil.getLogInfo(s, params), e);
    }

    @Override
    public void error(String s, Object ... params) {
        this.log.log(Level.SEVERE, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void debug(String s, Object ... params) {
        this.log.log(Level.FINE, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void trace(String s, Object ... params) {
        this.log.log(Level.FINER, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void warn(String s, Object ... params) {
        this.log.log(Level.WARNING, LogUtil.getLogInfo(s, params));
    }

    @Override
    public void info(String s, Object ... params) {
        this.log.log(Level.INFO, LogUtil.getLogInfo(s, params));
    }
}

