/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.driver;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.github.searls.jasmine.driver.QuietHtmlUnitDriver;
import com.google.common.base.Objects;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class WebDriverFactory {
    private boolean debug;
    private String browserVersion;
    private String webDriverClassName;
    private Map<String, String> webDriverCapabilities;

    public WebDriverFactory() {
        this.setWebDriverCapabilities(null);
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setBrowserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
    }

    public void setWebDriverClassName(String webDriverClassName) {
        this.webDriverClassName = webDriverClassName;
    }

    public void setWebDriverCapabilities(Map<String, String> webDriverCapabilities) {
        this.webDriverCapabilities = (Map)Objects.firstNonNull(webDriverCapabilities, Collections.emptyMap());
    }

    public WebDriver createWebDriver() throws Exception {
        if (HtmlUnitDriver.class.getName().equals(this.webDriverClassName)) {
            return this.createDefaultWebDriver();
        }
        return this.createCustomWebDriver();
    }

    private Class<? extends WebDriver> getWebDriverClass() throws Exception {
        return Class.forName(this.webDriverClassName);
    }

    private Constructor<? extends WebDriver> getWebDriverConstructor() throws Exception {
        Class<? extends WebDriver> webDriverClass = this.getWebDriverClass();
        try {
            return webDriverClass.getConstructor(Capabilities.class);
        }
        catch (Exception exception) {
            return webDriverClass.getConstructor(new Class[0]);
        }
    }

    private WebDriver createCustomWebDriver() throws Exception {
        Constructor<? extends WebDriver> constructor = this.getWebDriverConstructor();
        return constructor.newInstance(this.getWebDriverConstructorArguments(constructor));
    }

    private Object[] getWebDriverConstructorArguments(Constructor<? extends WebDriver> constructor) {
        if (constructor.getParameterTypes().length == 0) {
            return new Object[0];
        }
        return new Object[]{this.getCapabilities()};
    }

    private Capabilities getCapabilities() {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setJavascriptEnabled(true);
        for (Map.Entry<String, String> entry : this.webDriverCapabilities.entrySet()) {
            capabilities.setCapability(entry.getKey(), entry.getValue());
        }
        return capabilities;
    }

    private BrowserVersion getBrowserVersion() throws Exception {
        return (BrowserVersion)BrowserVersion.class.getField(this.browserVersion).get(BrowserVersion.class);
    }

    private WebDriver createDefaultWebDriver() throws Exception {
        return new QuietHtmlUnitDriver(this.getBrowserVersion(), this.debug);
    }
}

