/*
 * Decompiled with CFR 0.152.
 */
package com.github.searls.jasmine.runner;

import com.github.searls.jasmine.format.FormatsScriptTags;
import com.github.searls.jasmine.runner.HtmlGeneratorConfiguration;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.stringtemplate.v4.ST;

public abstract class AbstractSpecRunnerHtmlGenerator {
    private static final String SOURCE_ENCODING = "sourceEncoding";
    private static final String CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME = "cssDependencies";
    private static final String JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME = "javascriptDependencies";
    protected static final String SOURCES_TEMPLATE_ATTR_NAME = "sources";
    protected static final String REPORTER_ATTR_NAME = "reporter";
    private final HtmlGeneratorConfiguration configuration;
    private final FormatsScriptTags formatsScriptTags = new FormatsScriptTags();

    protected AbstractSpecRunnerHtmlGenerator(HtmlGeneratorConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void setEncoding(HtmlGeneratorConfiguration htmlGeneratorConfiguration, ST template) {
        template.add(SOURCE_ENCODING, (Object)(StringUtils.isNotBlank((String)htmlGeneratorConfiguration.getSourceEncoding()) ? htmlGeneratorConfiguration.getSourceEncoding() : "UTF-8"));
    }

    protected ST resolveHtmlTemplate() throws IOException {
        String htmlTemplate = this.configuration.getRunnerTemplate();
        return new ST(htmlTemplate, '$', '$');
    }

    protected void includeJavaScriptDependencies(List<String> dependencies, ST template) throws IOException {
        StringBuilder js = new StringBuilder();
        for (String jsFile : dependencies) {
            if (jsFile == null) continue;
            js.append("<script type=\"text/javascript\">").append(this.configuration.IOtoString(jsFile)).append("</script>");
        }
        template.add(JAVASCRIPT_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)js.toString());
    }

    protected void applyCssToTemplate(List<String> styles, ST template) throws IOException {
        StringBuilder css = new StringBuilder();
        for (String cssFile : styles) {
            css.append("<style type=\"text/css\">").append(this.configuration.IOtoString(cssFile)).append("</style>");
        }
        template.add(CSS_DEPENDENCIES_TEMPLATE_ATTR_NAME, (Object)css.toString());
    }

    public HtmlGeneratorConfiguration getConfiguration() {
        return this.configuration;
    }

    protected void applyScriptTagsToTemplate(String sourcesTemplateAttrName, Set<String> scripts, ST template) throws IOException {
        template.add(sourcesTemplateAttrName, (Object)this.formatsScriptTags.format(scripts));
    }
}

