/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.filter;

import com.power.common.util.StringUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RefererFilter
implements Filter {
    private static final long serialVersionUID = 1L;
    public static final String IGNORES = "ignores";
    private Set<String> excluded = null;

    public void init(FilterConfig fConfig) throws ServletException {
        String excludedString = fConfig.getInitParameter(IGNORES);
        this.excluded = excludedString != null ? Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(excludedString.split(";", 0)))) : Collections.emptySet();
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws ServletException, IOException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.isExcluded(request)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            request.getRequestDispatcher("/aa").forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    public void destroy() {
    }

    private boolean isExcluded(HttpServletRequest request) {
        String referer = request.getHeader("referer");
        if (StringUtil.isEmpty(referer)) {
            return true;
        }
        String severName = request.getServerName();
        if (referer.contains(severName)) {
            return true;
        }
        for (String url : this.excluded) {
            if (!referer.contains(url)) continue;
            return true;
        }
        return false;
    }
}

