/*
 * Decompiled with CFR 0.152.
 */
package com.power.common.util;

import com.power.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CollectionUtil {
    public static <T> boolean isNotEmpty(Collection<T> c) {
        return c != null && c.size() != 0;
    }

    public static <T> boolean isEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static <T> List<T> subList(List<T> source, int from, int to) {
        if (CollectionUtil.isEmpty(source)) {
            return null;
        }
        int size = source.size();
        if (to > size) {
            return source.subList(from, size);
        }
        return source.subList(from, to);
    }

    public static <T> List<T> asList(T ... a) {
        if (null != a) {
            return Arrays.asList(a);
        }
        return new ArrayList(0);
    }

    public static <T> List<T> mergeAndSwap(List<T> result1, List<T> result2) {
        if (CollectionUtil.isEmpty(result1) && CollectionUtil.isEmpty(result2)) {
            return new ArrayList(0);
        }
        if (CollectionUtil.isEmpty(result1) && CollectionUtil.isNotEmpty(result2)) {
            return result2;
        }
        if (CollectionUtil.isNotEmpty(result1) && CollectionUtil.isEmpty(result2)) {
            return result1;
        }
        int a = result1.size();
        int b = result2.size();
        int size = a + b;
        ArrayList<T> finalResult = new ArrayList<T>(size);
        if (a >= b) {
            for (int i = 0; i < size; ++i) {
                if (i > (b << 1) - 1) {
                    finalResult.add(result1.get(i - b));
                } else if ((i & 1) == 0 && i >> 1 < a) {
                    finalResult.add(result1.get(i >> 1));
                }
                if ((i & 1) != 1 || i - 1 >> 1 >= b) continue;
                finalResult.add(result2.get(i - 1 >> 1));
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if ((i & 1) == 0 && i >> 1 < a) {
                    finalResult.add(result1.get(i >> 1));
                }
                if ((i & 1) == 1 && i >> 1 < a - 1) {
                    finalResult.add(result2.get(i - 1 >> 1));
                }
                if (i < (a << 1) - 1) continue;
                finalResult.add(result2.get(i - a));
            }
        }
        return finalResult;
    }

    public static <T> List<List<T>> splitList(List<T> list, int pageSize) {
        ArrayList<List<T>> listArray = new ArrayList<List<T>>();
        if (list != null && list.size() > 0) {
            int listSize = list.size();
            int page = (listSize + (pageSize - 1)) / pageSize;
            for (int i = 0; i < page; ++i) {
                ArrayList<T> subList = new ArrayList<T>();
                for (int j = 0; j < listSize; ++j) {
                    int pageIndex = (j + 1 + (pageSize - 1)) / pageSize;
                    if (pageIndex == i + 1) {
                        subList.add(list.get(j));
                    }
                    if (j + 1 == (j + 1) * pageSize) break;
                }
                listArray.add(subList);
            }
        }
        return listArray;
    }

    public static List<Map<String, Object>> filterEmpty(List<Map<String, Object>> list, String ... exceptKeys) {
        ArrayList<Map<String, Object>> tempList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : list) {
            int a = map.size();
            int counter = 0;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                for (String str : exceptKeys) {
                    if (entry.getKey().equals(str)) continue;
                    Object value = entry.getValue();
                    if (value instanceof String) {
                        if (!StringUtil.isEmpty(String.valueOf(value))) continue;
                        ++counter;
                        continue;
                    }
                    if (null != value) continue;
                    ++counter;
                }
            }
            if (counter >= a - exceptKeys.length) continue;
            tempList.add(map);
        }
        return tempList;
    }
}

