/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean;

import java.util.List;
import jetbrick.bean.Executable;
import jetbrick.util.ClassUtils;

public final class ExecutableUtils {
    public static <T extends Executable> T getExecutable(List<T> executables, String name, Class<?> ... parameterTypes) {
        for (Executable info : executables) {
            Class<?>[] types;
            if (name != null && !info.getName().equals(name) || parameterTypes.length != (types = info.getParameterTypes()).length) continue;
            boolean match = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (types[i] == parameterTypes[i]) continue;
                match = false;
                break;
            }
            if (!match) continue;
            return (T)info;
        }
        return null;
    }

    public static <T extends Executable> T searchExecutable(List<T> executables, String name, Class<?> ... parameterTypes) {
        Executable best = null;
        Class<?>[] bestParametersTypes = null;
        for (Executable execute : executables) {
            Class<?>[] types;
            if (name != null && !execute.getName().equals(name) || !ExecutableUtils.isParameterTypesCompatible(types = execute.getParameterTypes(), parameterTypes, execute.isVarArgs(), false)) continue;
            if (best == null) {
                best = execute;
                bestParametersTypes = types;
                continue;
            }
            if (best.isVarArgs() && !execute.isVarArgs()) {
                best = execute;
                bestParametersTypes = types;
                continue;
            }
            if (!best.isVarArgs() && execute.isVarArgs() || !ExecutableUtils.isParameterTypesCompatible(bestParametersTypes, types, best.isVarArgs(), execute.isVarArgs())) continue;
            best = execute;
            bestParametersTypes = types;
        }
        return (T)best;
    }

    public static boolean isParameterTypesCompatible(Class<?>[] lhs, Class<?>[] rhs, boolean lhsVarArgs, boolean rhsVarArgs) {
        if (lhs == null) {
            return rhs == null || rhs.length == 0;
        }
        if (rhs == null) {
            return lhs.length == 0;
        }
        if (lhsVarArgs && rhsVarArgs) {
            Class<?> c2;
            if (lhs.length != rhs.length) {
                return false;
            }
            for (int i = 0; i < lhs.length - 1; ++i) {
                if (ClassUtils.isAssignable(lhs[i], rhs[i])) continue;
                return false;
            }
            Class<?> c1 = lhs[lhs.length - 1].getComponentType();
            if (!ClassUtils.isAssignable(c1, c2 = rhs[rhs.length - 1].getComponentType())) {
                return false;
            }
        } else if (lhsVarArgs) {
            if (lhs.length - 1 > rhs.length) {
                return false;
            }
            for (int i = 0; i < lhs.length - 1; ++i) {
                if (ClassUtils.isAssignable(lhs[i], rhs[i])) continue;
                return false;
            }
            Class<?> varType = lhs[lhs.length - 1].getComponentType();
            for (int i = lhs.length - 1; i < rhs.length; ++i) {
                if (ClassUtils.isAssignable(varType, rhs[i])) continue;
                return false;
            }
        } else {
            if (lhs.length != rhs.length) {
                return false;
            }
            for (int i = 0; i < lhs.length; ++i) {
                if (ClassUtils.isAssignable(lhs[i], rhs[i])) continue;
                return false;
            }
        }
        return true;
    }
}

