/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.bean.asm;

import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.List;
import jetbrick.bean.asm.AsmAccessor;

final class AsmClassLoader
extends ClassLoader {
    private static final String ASMACCESSOR_CLASS_NAME = AsmAccessor.class.getName();
    private static final List<AsmClassLoader> ASM_CLASS_LOADERS = new ArrayList<AsmClassLoader>();
    private static final ClassLoader PARENT_ASM_CLASS_LOADER = AsmClassLoader.class.getClassLoader();
    private static final AsmClassLoader DEFAULT_ASM_CLASS_LOADER = new AsmClassLoader(PARENT_ASM_CLASS_LOADER);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AsmClassLoader get(Class<?> type) {
        ClassLoader parent = type.getClassLoader();
        if (PARENT_ASM_CLASS_LOADER == parent) {
            return DEFAULT_ASM_CLASS_LOADER;
        }
        List<AsmClassLoader> list = ASM_CLASS_LOADERS;
        synchronized (list) {
            int n = ASM_CLASS_LOADERS.size();
            for (int i = 0; i < n; ++i) {
                AsmClassLoader loader = ASM_CLASS_LOADERS.get(i);
                if (loader.getParent() != parent) continue;
                return loader;
            }
            AsmClassLoader loader = new AsmClassLoader(parent);
            ASM_CLASS_LOADERS.add(loader);
            return loader;
        }
    }

    private AsmClassLoader(ClassLoader parent) {
        super(parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.equals(ASMACCESSOR_CLASS_NAME)) {
            return AsmAccessor.class;
        }
        return super.loadClass(name, resolve);
    }

    protected Class<?> defineClass(String qualifiedClassName, byte[] bytes, ProtectionDomain protectionDomain) throws ClassFormatError {
        return super.defineClass(qualifiedClassName, bytes, 0, bytes.length, protectionDomain);
    }
}

