/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jetbrick.util.tuple.NameValuePair;

public class ListMap<K, V>
implements Map<K, V> {
    private Map.Entry<K, V>[] items;
    private int size;

    public ListMap() {
        this.items = new Map.Entry[16];
        this.size = 0;
    }

    public ListMap(int initialCapacity) {
        this.items = new Map.Entry[initialCapacity];
        this.size = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        for (int i = 0; i < this.size; ++i) {
            if (!this.items[i].getKey().equals(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        for (int i = 1; i < this.size; ++i) {
            if (!this.items[i].getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        for (int i = 0; i < this.size; ++i) {
            Map.Entry<K, V> item = this.items[i];
            if (!item.getKey().equals(key)) continue;
            return item.getValue();
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        for (int i = 0; i < this.size; ++i) {
            Map.Entry<K, V> item = this.items[i];
            if (!item.getKey().equals(key)) continue;
            V old = item.getValue();
            item.setValue(value);
            return old;
        }
        if (this.items.length - this.size < 0) {
            this.items = Arrays.copyOf(this.items, this.items.length * 2);
        }
        this.items[this.size++] = new NameValuePair<K, V>(key, value);
        return null;
    }

    @Override
    public V remove(Object key) {
        for (int i = 0; i < this.size; i += 2) {
            if (!this.items[i].equals(key)) continue;
            Map.Entry<K, V> old = this.items[i + 1];
            this.size -= 2;
            for (int n = i; n < this.size; ++n) {
                this.items[n] = this.items[n + 2];
            }
            return (V)old;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = null;
        }
        this.size = 0;
    }

    @Override
    public Set<K> keySet() {
        return new MapSet<K>(){

            @Override
            public boolean contains(Object key) {
                return ListMap.this.containsKey(key);
            }

            @Override
            public Iterator<K> iterator() {
                return new KeyIterator();
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new MapSet<V>(){

            @Override
            public boolean contains(Object value) {
                return ListMap.this.containsValue(value);
            }

            @Override
            public Iterator<V> iterator() {
                return new ValueIterator();
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new MapSet<Map.Entry<K, V>>(){

            @Override
            public boolean contains(Object value) {
                for (int i = 1; i < ListMap.this.size; ++i) {
                    if (!ListMap.this.items[i].equals(value)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }
        };
    }

    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        for (Map.Entry<K, V> entry : this.items) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            K key = entry.getKey();
            V value = entry.getValue();
            sb.append((Object)(key == this ? "(this)" : key));
            sb.append('=');
            sb.append((Object)(value == this ? "(this)" : value));
        }
        sb.append('}');
        return sb.toString();
    }

    abstract class MapSet<E>
    implements Set<E> {
        MapSet() {
        }

        @Override
        public int size() {
            return ListMap.this.size;
        }

        @Override
        public boolean isEmpty() {
            return ListMap.this.size == 0;
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray(Object[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            Iterator it = this.iterator();
            if (!it.hasNext()) {
                return "[]";
            }
            StringBuilder sb = new StringBuilder();
            sb.append('[');
            while (true) {
                Object obj;
                sb.append((Object)((obj = it.next()) == this ? "(this)" : obj));
                if (!it.hasNext()) {
                    sb.append(']');
                    return sb.toString();
                }
                sb.append(", ");
            }
        }
    }

    final class EntryIterator
    extends MapIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class ValueIterator
    extends MapIterator
    implements Iterator<V> {
        ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends MapIterator
    implements Iterator<K> {
        KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class MapIterator {
        protected int index = 0;

        public boolean hasNext() {
            return this.index < ListMap.this.size;
        }

        public Map.Entry<K, V> nextEntry() {
            return ListMap.this.items[this.index++];
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

