/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import jetbrick.io.IoUtils;

public class MultiLinesFile {
    protected Properties props = new Properties();

    public MultiLinesFile(File file, String encoding) {
        FileInputStream fs = null;
        try {
            fs = new FileInputStream(file);
            this.load(new BufferedReader(new InputStreamReader((InputStream)fs, encoding)));
        }
        catch (IOException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fs);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(fs);
    }

    public MultiLinesFile(InputStream is, String encoding) {
        try {
            this.load(new BufferedReader(new InputStreamReader(is, encoding)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public MultiLinesFile(Reader reader) {
        try {
            if (!(reader instanceof BufferedReader)) {
                reader = new BufferedReader(reader);
            }
            this.load((BufferedReader)reader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void load(BufferedReader reader) throws IOException {
        String line = null;
        String key = null;
        StringBuilder values = new StringBuilder(64);
        while ((line = reader.readLine()) != null) {
            String str = line.trim();
            if (str.startsWith("#")) continue;
            if (str.startsWith("[") && str.endsWith("]")) {
                if (key != null) {
                    this.props.put(key, values.toString());
                }
                key = str.substring(1, str.length() - 1).trim();
                values.setLength(0);
                continue;
            }
            values.append(line).append("\n");
        }
        if (key != null) {
            this.props.put(key, values.toString());
        }
    }

    public boolean exist(String key) {
        return this.props.containsKey(key);
    }

    public String getProperty(String key) {
        return this.props.getProperty(key);
    }

    public Properties getProperties() {
        return this.props;
    }
}

