/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jetbrick.bean.TypeResolverUtils;
import jetbrick.event.AppEvent;
import jetbrick.event.AppEventListener;
import jetbrick.event.AppListener;

public final class AppEventPublisher {
    private static final List<AppEventListenerAgent> listeners = new ArrayList<AppEventListenerAgent>();
    private static volatile ExecutorService executorService;

    public static void setExecutorService(ExecutorService executorService) {
        AppEventPublisher.executorService = executorService;
    }

    public static void addEventListener(AppEventListener listener) {
        Class<?> cls = listener.getClass();
        AppListener annotation = cls.getAnnotation(AppListener.class);
        AppEventListenerAgent agent = new AppEventListenerAgent();
        agent.listener = listener;
        agent.type = annotation.type();
        agent.async = annotation.async();
        agent.order = annotation.order();
        if (agent.type == AppEvent.NULL.class) {
            agent.type = TypeResolverUtils.getRawType(AppEventListener.class.getTypeParameters()[0], cls);
        }
        listeners.add(agent);
        Collections.sort(listeners);
    }

    public static void publishEvent(final AppEvent event) {
        for (AppEventListenerAgent agent : listeners) {
            if (agent.async || !agent.type.isInstance(event)) continue;
            agent.listener.onAppEvent(event);
        }
        ExecutorService executorService = AppEventPublisher.getExecutorService();
        for (final AppEventListenerAgent agent : listeners) {
            if (!agent.async || !agent.type.isInstance(event)) continue;
            executorService.submit(new Runnable(){

                @Override
                public void run() {
                    agent.listener.onAppEvent(event);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ExecutorService getExecutorService() {
        if (executorService != null) return executorService;
        Class<AppEventPublisher> clazz = AppEventPublisher.class;
        synchronized (AppEventPublisher.class) {
            if (executorService != null) return executorService;
            executorService = Executors.newFixedThreadPool(10);
            // ** MonitorExit[var0] (shouldn't be in output)
            return executorService;
        }
    }

    static class AppEventListenerAgent
    implements Comparable<AppEventListenerAgent> {
        private AppEventListener listener;
        private Class<? extends AppEvent> type;
        private boolean async;
        private int order;

        AppEventListenerAgent() {
        }

        @Override
        public int compareTo(AppEventListenerAgent o) {
            return this.order - o.order;
        }
    }
}

