/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URLConnection;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.util.zip.ZipFile;
import jetbrick.io.stream.ReaderInputStream;
import jetbrick.io.stream.UnsafeByteArrayOutputStream;
import jetbrick.io.stream.UnsafeCharArrayWriter;

public final class IoUtils {
    private static final int DEFAULT_BUFFER_SIZE = 8192;

    public static byte[] toByteArray(File file) {
        byte[] byArray;
        FileInputStream is = null;
        try {
            is = new FileInputStream(file);
            byArray = IoUtils.toByteArray(is);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(is);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(is);
        return byArray;
    }

    public static byte[] toByteArray(InputStream is) {
        UnsafeByteArrayOutputStream out = new UnsafeByteArrayOutputStream();
        try {
            byte[] buffer = new byte[8192];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    public static byte[] toByteArray(Reader reader, String charsetName) {
        return IoUtils.toByteArray(reader, Charset.forName(charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(Reader reader, Charset charset) {
        try {
            ReaderInputStream is = new ReaderInputStream(reader, charset);
            byte[] byArray = IoUtils.toByteArray(is);
            return byArray;
        }
        finally {
            IoUtils.closeQuietly(reader);
        }
    }

    public static char[] toCharArray(File file, String charsetName) {
        return IoUtils.toCharArray(file, Charset.forName(charsetName));
    }

    public static char[] toCharArray(File file, Charset charset) {
        char[] cArray;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            cArray = IoUtils.toCharArray(reader);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        return cArray;
    }

    public static char[] toCharArray(InputStream is, String charsetName) {
        return IoUtils.toCharArray(is, Charset.forName(charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] toCharArray(InputStream is, Charset charset) {
        char[] cArray;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(is, charset);
            cArray = IoUtils.toCharArray(reader);
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(reader);
            throw throwable;
        }
        IoUtils.closeQuietly(reader);
        return cArray;
    }

    public static char[] toCharArray(Reader reader) {
        UnsafeCharArrayWriter out = new UnsafeCharArrayWriter();
        try {
            char[] buffer = new char[8192];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                out.write(buffer, 0, n);
            }
            char[] cArray = out.toCharArray();
            return cArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    public static String toString(File file, String charsetName) {
        return IoUtils.toString(file, Charset.forName(charsetName));
    }

    public static String toString(File file, Charset charset) {
        String string;
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            string = IoUtils.toString(reader);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(reader);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(reader);
        return string;
    }

    public static String toString(InputStream is, String charsetName) {
        return IoUtils.toString(is, Charset.forName(charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toString(InputStream is, Charset charset) {
        try {
            InputStreamReader reader = new InputStreamReader(is, charset);
            String string = IoUtils.toString(reader);
            return string;
        }
        finally {
            IoUtils.closeQuietly(is);
        }
    }

    public static String toString(Reader reader) {
        UnsafeCharArrayWriter out = new UnsafeCharArrayWriter();
        try {
            char[] buffer = new char[8192];
            int n = 0;
            while (-1 != (n = reader.read(buffer))) {
                out.write(buffer, 0, n);
            }
            String string = out.toString();
            return string;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            IoUtils.closeQuietly(out);
        }
    }

    public static void write(byte[] data, File file) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data);
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(os);
    }

    public static void write(char[] data, File file, String charsetName) {
        IoUtils.write(data, file, Charset.forName(charsetName));
    }

    public static void write(char[] data, File file, Charset charset) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(new String(data).getBytes(charset));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(os);
    }

    public static void write(String data, File file, String charsetName) {
        IoUtils.write(data, file, Charset.forName(charsetName));
    }

    public static void write(String data, File file, Charset charset) {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            ((OutputStream)os).write(data.getBytes(charset));
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(os);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(os);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[8192];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, Writer output, String charsetName) throws IOException {
        return IoUtils.copy(new InputStreamReader(input, Charset.forName(charsetName)), output);
    }

    public static long copy(InputStream input, Writer output, Charset charset) throws IOException {
        return IoUtils.copy(new InputStreamReader(input, charset), output);
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[8192];
        long count = 0L;
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(Reader input, OutputStream output, String charsetName) throws IOException {
        return IoUtils.copy(new ReaderInputStream(input, Charset.forName(charsetName)), output);
    }

    public static long copy(Reader input, OutputStream output, Charset charset) throws IOException {
        return IoUtils.copy(new ReaderInputStream(input, charset), output);
    }

    public static void closeQuietly(Closeable obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ZipFile obj) {
        try {
            if (obj != null) {
                obj.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Socket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        try {
            if (socket != null) {
                socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Selector selector) {
        try {
            if (selector != null) {
                selector.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(URLConnection conn) {
        if (conn != null && conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).disconnect();
        }
    }
}

