/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.Validate;

public final class FileSystemResource
extends AbstractResource {
    private final File file;

    public FileSystemResource(File file) {
        this.file = file;
        this.relativePathName = file.getPath();
    }

    public FileSystemResource(URL url) {
        Validate.notNull(url);
        String file = url.getPath();
        try {
            file = URLDecoder.decode(file, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
        this.file = new File(file);
        this.relativePathName = file;
    }

    @Override
    public InputStream openStream() throws ResourceNotFoundException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException(e);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public URI getURI() {
        return this.file.toURI();
    }

    @Override
    public URL getURL() {
        try {
            return this.file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getFileName() {
        return this.file.getName();
    }

    @Override
    public boolean exist() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.file.toString();
    }
}

