/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.PathUtils;
import jetbrick.util.Validate;

public final class ServletResource
extends AbstractResource {
    private final String path;
    private final File file;
    private final URL url;

    public ServletResource(ServletContext sc, String path) {
        Validate.notNull(sc);
        Validate.notNull(path);
        this.path = path;
        this.relativePathName = path;
        try {
            String realPath = sc.getRealPath(path);
            if (realPath != null) {
                this.file = new File(realPath);
                this.url = null;
            } else {
                this.file = null;
                this.url = sc.getResource(path);
            }
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public InputStream openStream() throws ResourceNotFoundException {
        if (this.file == null && this.url == null) {
            throw new ResourceNotFoundException(this.path);
        }
        try {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public File getFile() throws ResourceNotFoundException {
        if (this.file != null) {
            return this.file;
        }
        if (this.url != null) {
            return PathUtils.urlAsFile(this.url);
        }
        throw new ResourceNotFoundException(this.path);
    }

    @Override
    public URL getURL() {
        if (this.url != null) {
            return this.url;
        }
        if (this.file != null) {
            try {
                return this.file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    @Override
    public boolean exist() {
        return this.file != null && this.file.exists() || this.url != null;
    }

    @Override
    public boolean isDirectory() {
        return this.path.endsWith("/");
    }

    @Override
    public boolean isFile() {
        return !this.path.endsWith("/");
    }

    @Override
    public long length() {
        if (this.file != null) {
            return this.file.length();
        }
        if (this.url != null) {
            try {
                return this.url.openConnection().getContentLengthLong();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return -1L;
    }

    @Override
    public long lastModified() {
        if (this.file != null) {
            return this.file.lastModified();
        }
        if (this.url != null) {
            try {
                return this.url.openConnection().getLastModified();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return 0L;
    }

    public String toString() {
        return "webroot:" + this.path;
    }
}

