/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.io.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import jetbrick.io.resource.AbstractResource;
import jetbrick.io.resource.ResourceNotFoundException;
import jetbrick.util.Validate;

public class UrlResource
extends AbstractResource {
    protected final URL url;

    public UrlResource(URL url) {
        Validate.notNull(url);
        this.url = url;
        this.relativePathName = url.toString();
    }

    @Override
    public InputStream openStream() throws ResourceNotFoundException {
        if (this.url == null) {
            throw new ResourceNotFoundException();
        }
        try {
            return this.url.openStream();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public boolean exist() {
        return this.url != null;
    }

    @Override
    public boolean isDirectory() {
        return this.relativePathName.endsWith("/");
    }

    @Override
    public boolean isFile() {
        return !this.relativePathName.endsWith("/");
    }

    @Override
    public long length() {
        try {
            return this.url.openConnection().getContentLengthLong();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public long lastModified() {
        try {
            return this.url.openConnection().getLastModified();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.url.toString();
    }
}

