/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import jetbrick.io.resource.Resource;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.support.ArrayConvertor;
import jetbrick.typecast.support.BigDecimalConvertor;
import jetbrick.typecast.support.BigIntegerConvertor;
import jetbrick.typecast.support.BooleanConvertor;
import jetbrick.typecast.support.ByteConvertor;
import jetbrick.typecast.support.CalendarConvertor;
import jetbrick.typecast.support.CharacterConvertor;
import jetbrick.typecast.support.CharsetConvertor;
import jetbrick.typecast.support.ClassConvertor;
import jetbrick.typecast.support.DateConvertor;
import jetbrick.typecast.support.DoubleConvertor;
import jetbrick.typecast.support.FileConvertor;
import jetbrick.typecast.support.FloatConvertor;
import jetbrick.typecast.support.InstantConvertor;
import jetbrick.typecast.support.IntegerConvertor;
import jetbrick.typecast.support.ListConvertor;
import jetbrick.typecast.support.LocalDateConvertor;
import jetbrick.typecast.support.LocalDateTimeConvertor;
import jetbrick.typecast.support.LocalTimeConvertor;
import jetbrick.typecast.support.LocaleConvertor;
import jetbrick.typecast.support.LongConvertor;
import jetbrick.typecast.support.PathConvertor;
import jetbrick.typecast.support.PrimitiveArrayConvertor;
import jetbrick.typecast.support.ResourceConvertor;
import jetbrick.typecast.support.ShortConvertor;
import jetbrick.typecast.support.SqlDateConvertor;
import jetbrick.typecast.support.SqlTimeConvertor;
import jetbrick.typecast.support.SqlTimestampConvertor;
import jetbrick.typecast.support.StringConvertor;
import jetbrick.typecast.support.TimeZoneConvertor;
import jetbrick.typecast.support.URIConvertor;
import jetbrick.typecast.support.URLConvertor;
import jetbrick.util.JdkUtils;

public final class TypeCastResolver {
    private final Map<Class<?>, Convertor<?>> pool = new IdentityHashMap(64);
    private final Map<Class<?>, ListConvertor<?>> listPool = new IdentityHashMap(64);
    private final Map<Class<?>, ArrayConvertor<?>> objectArrayPool = new IdentityHashMap(64);
    private final Map<Class<?>, PrimitiveArrayConvertor<?>> primitiveArrayPool = new IdentityHashMap(16);

    public TypeCastResolver() {
        this.register(Byte.class, ByteConvertor.INSTANCE);
        this.register(Byte.TYPE, ByteConvertor.INSTANCE);
        this.register(Short.class, ShortConvertor.INSTANCE);
        this.register(Short.TYPE, ShortConvertor.INSTANCE);
        this.register(Integer.class, IntegerConvertor.INSTANCE);
        this.register(Integer.TYPE, IntegerConvertor.INSTANCE);
        this.register(Long.class, LongConvertor.INSTANCE);
        this.register(Long.TYPE, LongConvertor.INSTANCE);
        this.register(Float.class, FloatConvertor.INSTANCE);
        this.register(Float.TYPE, FloatConvertor.INSTANCE);
        this.register(Double.class, DoubleConvertor.INSTANCE);
        this.register(Double.TYPE, DoubleConvertor.INSTANCE);
        this.register(Character.class, CharacterConvertor.INSTANCE);
        this.register(Character.TYPE, CharacterConvertor.INSTANCE);
        this.register(Boolean.class, BooleanConvertor.INSTANCE);
        this.register(Boolean.TYPE, BooleanConvertor.INSTANCE);
        this.register(BigInteger.class, BigIntegerConvertor.INSTANCE);
        this.register(BigDecimal.class, BigDecimalConvertor.INSTANCE);
        this.register(String.class, StringConvertor.INSTANCE);
        this.register(Class.class, ClassConvertor.INSTANCE);
        this.register(Charset.class, CharsetConvertor.INSTANCE);
        this.register(java.util.Date.class, DateConvertor.INSTANCE);
        this.register(Date.class, SqlDateConvertor.INSTANCE);
        this.register(Time.class, SqlTimeConvertor.INSTANCE);
        this.register(Timestamp.class, SqlTimestampConvertor.INSTANCE);
        this.register(Calendar.class, CalendarConvertor.INSTANCE);
        this.register(GregorianCalendar.class, CalendarConvertor.INSTANCE);
        this.register(Locale.class, LocaleConvertor.INSTANCE);
        this.register(TimeZone.class, TimeZoneConvertor.INSTANCE);
        this.register(File.class, FileConvertor.INSTANCE);
        this.register(URI.class, URIConvertor.INSTANCE);
        this.register(URL.class, URLConvertor.INSTANCE);
        this.register(Resource.class, ResourceConvertor.INSTANCE);
        if (JdkUtils.IS_AT_LEAST_JAVA_7) {
            this.registerWhenJdk7();
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_8) {
            this.registerWhenJdk8();
        }
    }

    private void registerWhenJdk7() {
        this.register(Path.class, PathConvertor.INSTANCE);
    }

    private void registerWhenJdk8() {
        this.register(Instant.class, InstantConvertor.INSTANCE);
        this.register(LocalDateTime.class, LocalDateTimeConvertor.INSTANCE);
        this.register(LocalDate.class, LocalDateConvertor.INSTANCE);
        this.register(LocalTime.class, LocalTimeConvertor.INSTANCE);
    }

    public <T> void register(Class<?> type, Convertor<?> convertor) {
        this.pool.put(type, convertor);
        if (type.isPrimitive()) {
            this.primitiveArrayPool.put(type, new PrimitiveArrayConvertor(type));
        } else {
            this.objectArrayPool.put(type, new ArrayConvertor(type, convertor));
            this.listPool.put(type, new ListConvertor(type, convertor));
        }
    }

    public void unregister(Class<?> type) {
        this.pool.remove(type);
        if (type.isPrimitive()) {
            this.primitiveArrayPool.remove(type);
        } else {
            this.objectArrayPool.remove(type);
            this.listPool.remove(type);
        }
    }

    public <T> Convertor<T> lookup(Class<T> type) {
        return this.pool.get(type);
    }

    public <T> T convert(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type == String.class) {
            return (T)value;
        }
        Convertor<?> c = this.pool.get(type);
        if (c != null) {
            return (T)c.convert(value);
        }
        if (type.isArray()) {
            return this.convertToArray(value, type.getComponentType());
        }
        throw new IllegalStateException("Unsupported cast class: " + type.getName());
    }

    public <T> T convertToArray(String value, Class<?> elementType) {
        if (elementType.isPrimitive()) {
            PrimitiveArrayConvertor<?> c = this.primitiveArrayPool.get(elementType);
            if (c != null) {
                return (T)c.convert(value);
            }
        } else {
            ArrayConvertor<?> c = this.objectArrayPool.get(elementType);
            if (c != null) {
                return (T)c.convert(value);
            }
        }
        throw new IllegalStateException("Cannot cast to array: " + elementType.getName() + "[]");
    }

    public <T> List<T> convertToList(String value, Class<T> elementType) {
        ListConvertor<?> c = this.listPool.get(elementType);
        if (c != null) {
            return c.convert(value);
        }
        throw new IllegalStateException("Cannot cast to class: List<" + elementType.getName() + ">");
    }

    public <T> T convert(Object value, Class<T> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (T)value;
        }
        Convertor<?> c = this.pool.get(type);
        if (c != null) {
            return (T)c.convert(value);
        }
        if (type.isArray()) {
            return this.convertToArray(value, type.getComponentType());
        }
        throw new IllegalStateException("Unsupported cast class: " + type.getName());
    }

    public <T> T convertToArray(Object value, Class<?> elementType) {
        if (elementType.isPrimitive()) {
            PrimitiveArrayConvertor<?> c = this.primitiveArrayPool.get(elementType);
            if (c != null) {
                return (T)c.convert(value);
            }
        } else {
            ArrayConvertor<?> c = this.objectArrayPool.get(elementType);
            if (c != null) {
                return (T)c.convert(value);
            }
        }
        throw new IllegalStateException("Cannot cast to array: " + elementType.getName() + "[]");
    }

    public <T> List<T> convertToList(Object value, Class<T> elementType) {
        ListConvertor<?> c = this.listPool.get(elementType);
        if (c != null) {
            return c.convert(value);
        }
        throw new IllegalStateException("Cannot cast to class: List<" + elementType.getName() + ">");
    }
}

