/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast;

import java.util.List;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastResolver;

public final class TypeCastUtils {
    private static final TypeCastResolver resolver = new TypeCastResolver();

    public static <T> void register(Class<T> type, Convertor<T> convertor) {
        resolver.register(type, convertor);
    }

    public static boolean support(Class<?> type) {
        return resolver.lookup(type) != null;
    }

    public static <T> Convertor<T> lookup(Class<T> type) {
        return resolver.lookup(type);
    }

    public static <T> T convert(String value, Class<T> type) {
        return resolver.convert(value, type);
    }

    public static <T> T convert(Object value, Class<T> type) {
        return resolver.convert(value, type);
    }

    public static <T> T convertToArray(String value, Class<?> elementType) {
        return resolver.convertToArray(value, elementType);
    }

    public static <T> T convertToArray(Object value, Class<?> elementType) {
        return resolver.convertToArray(value, elementType);
    }

    public static <T> List<T> convertToList(String value, Class<T> elementType) {
        return resolver.convertToList(value, elementType);
    }

    public static <T> List<T> convertToList(Object value, Class<T> elementType) {
        return resolver.convertToList(value, elementType);
    }
}

