/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.math.BigInteger;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;

public final class BigIntegerConvertor
implements Convertor<BigInteger> {
    public static final BigIntegerConvertor INSTANCE = new BigIntegerConvertor();

    @Override
    public BigInteger convert(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw TypeCastException.create(value, BigInteger.class, e);
        }
    }

    @Override
    public BigInteger convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigInteger) {
            return (BigInteger)value;
        }
        return this.convert(value.toString());
    }
}

