/*
 * Decompiled with CFR 0.152.
 */
package jetbrick.typecast.support;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import jetbrick.typecast.Convertor;
import jetbrick.typecast.TypeCastException;
import jetbrick.util.DateUtils;
import jetbrick.util.JdkUtils;

public final class DateConvertor
implements Convertor<Date> {
    public static final DateConvertor INSTANCE = new DateConvertor();

    @Override
    public Date convert(String value) {
        if (value == null) {
            return null;
        }
        return new Date(DateConvertor.toMilliseconds(value, Date.class));
    }

    @Override
    public Date convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return new Date(DateConvertor.toMilliseconds(value, Date.class));
    }

    protected static long toMilliseconds(String value, Class<?> targetClass) {
        if (value.matches("[0-9]+")) {
            try {
                long milliseconds = Long.parseLong(value);
                return milliseconds;
            }
            catch (NumberFormatException e) {
                throw TypeCastException.create(value, targetClass, e);
            }
        }
        Date date = DateUtils.parse(value);
        if (date == null) {
            throw TypeCastException.create(value, targetClass, null);
        }
        return date.getTime();
    }

    protected static long toMilliseconds(Object value, Class<?> targetClass) {
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (JdkUtils.IS_AT_LEAST_JAVA_8) {
            if (value instanceof Instant) {
                return ((Instant)value).toEpochMilli();
            }
            if (value instanceof LocalDateTime) {
                LocalDateTime dt = (LocalDateTime)value;
                ZoneOffset zone = ZoneOffset.of(ZoneId.systemDefault().getId());
                return dt.toInstant(zone).toEpochMilli();
            }
            if (value instanceof LocalDate) {
                LocalDate dt = (LocalDate)value;
                Calendar cal = Calendar.getInstance();
                cal.set(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), 0, 0, 0);
                cal.set(14, 0);
                return cal.getTimeInMillis();
            }
            if (value instanceof LocalTime) {
                LocalTime dt = (LocalTime)value;
                Calendar cal = Calendar.getInstance();
                cal.set(0, 0, 0, dt.getHour(), dt.getMinute(), dt.getSecond());
                cal.set(14, dt.getNano() / 1000000);
                return cal.getTimeInMillis();
            }
        }
        return DateConvertor.toMilliseconds(value.toString(), targetClass);
    }
}

